import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Alert, AlertVariant } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { useDmnEditorStore } from "../store/StoreContext";
import { useMemo } from "react";
import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { useDmnEditor } from "../DmnEditorContext";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export function UnknownProperties(props) {
    const thisDmn = useDmnEditorStore((s) => s.dmn);
    const { externalModelsByNamespace } = useExternalModels();
    const externalDmnsByNamespace = useDmnEditorStore((s) => s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns);
    const { onRequestToJumpToPath } = useDmnEditor();
    const content = useMemo(() => {
        var _a;
        const namespace = thisDmn.model.definitions[`@_xmlns:${props.dmnElementRefQName.prefix}`];
        if (!namespace) {
            return _jsx("p", { children: `This node references an external node with a namespace that is not declared at this DMN.` });
        }
        const externalDmn = externalDmnsByNamespace.get(namespace);
        if (!externalDmn) {
            return (_jsx("p", { children: `This node references an external node from a namespace that is not provided on this DMN's external DMNs mapping. ` }));
        }
        const externalDrgElementsById = ((_a = externalDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).reduce((acc, e, index) => acc.set(e["@_id"], { element: e, index }), new Map());
        const externalDrgElement = externalDrgElementsById.get(props.dmnElementRefQName.localPart);
        if (!externalDrgElement) {
            return (_jsxs(_Fragment, { children: [_jsx("p", { children: `This node references a DRG element from '${externalDmn.model.definitions["@_name"]}' that doesn't exist.` }), onRequestToJumpToPath && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx(Button, { style: { paddingLeft: 0 }, variant: ButtonVariant.link, onClick: () => onRequestToJumpToPath === null || onRequestToJumpToPath === void 0 ? void 0 : onRequestToJumpToPath(externalDmn.normalizedPosixPathRelativeToTheOpenFile), children: `Go to '${externalDmn.model.definitions["@_name"]}'` })] }))] }));
        }
    }, [
        externalDmnsByNamespace,
        onRequestToJumpToPath,
        props.dmnElementRefQName.localPart,
        props.dmnElementRefQName.prefix,
        thisDmn.model.definitions,
    ]);
    return (_jsx(_Fragment, { children: _jsxs(Alert, { title: "This is a placeholder for an unknown node", isInline: true, variant: AlertVariant.danger, children: [_jsx("br", {}), content, _jsx(Divider, { style: { marginTop: "16px" } }), _jsx("br", {}), _jsxs("p", { children: [_jsx("b", { children: "Reference:" }), "\u00A0", `${buildXmlQName(props.dmnElementRefQName)}`] })] }) }));
}
//# sourceMappingURL=UnknownProperties.js.map