import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { IdentifiersRefactor } from "@kie-tools/dmn-language-service";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useCallback, useMemo, useState } from "react";
import { renameDrgElement } from "../mutations/renameNode";
export function RefactorConfirmationDialog({ onConfirmExpressionRefactor, onConfirmRenameOnly, onCancel, isRefactorModalOpen, fromName, toName, }) {
    return (_jsxs(Modal, { "aria-labelledby": "identifier-renamed", variant: ModalVariant.small, isOpen: isRefactorModalOpen, showClose: true, onClose: onCancel, title: "Renaming identifier", actions: [
            _jsx(Button, { variant: ButtonVariant.primary, onClick: onConfirmExpressionRefactor, children: "Yes, rename and replace" }, "confirm"),
            _jsx(Button, { variant: ButtonVariant.secondary, onClick: onConfirmRenameOnly, children: "No, just rename" }, "rename"),
            _jsx(Button, { variant: ButtonVariant.link, onClick: onCancel, children: "Cancel" }, "cancel"),
        ], children: ["The identifier", " ", _jsxs("pre", { style: { display: "inline" }, children: ['"', fromName !== null && fromName !== void 0 ? fromName : "<undefined>", '"'] }), " ", "was renamed to", " ", _jsxs("pre", { style: { display: "inline" }, children: ['"', toName !== null && toName !== void 0 ? toName : "<undefined>", '"'] }), ", and it is used by one or more expressions.", _jsx("br", {}), _jsx("br", {}), "Would you like to automatically replace all occurrences of", " ", _jsxs("pre", { style: { display: "inline" }, children: ['"', fromName !== null && fromName !== void 0 ? fromName : "<undefined>", '"'] }), " ", "with", " ", _jsxs("pre", { style: { display: "inline" }, children: ['"', toName !== null && toName !== void 0 ? toName : "<undefined>", '"'] }), "?"] }));
}
export function isIdentifierReferencedInSomeExpression(args) {
    const identifiersRefactor = new IdentifiersRefactor({
        writeableDmnDefinitions: args.dmnDefinitions,
        _readonly_externalDmnModelsByNamespaceMap: args.externalDmnModelsByNamespaceMap,
    });
    return Array.from(identifiersRefactor.getExpressionsThatUseTheIdentifier(args.identifierUuid)).length > 0;
}
export function useRefactor({ index, identifierId, oldName, }) {
    const { externalModelsByNamespace } = useExternalModels();
    const externalDmnModelsByNamespaceMap = useDmnEditorStore((s) => s.computed(s).getExternalDmnModelsByNamespaceMap(externalModelsByNamespace));
    const [isRefactorModalOpen, setIsRefactorModalOpen] = useState(false);
    const [newName, setNewName] = useState("");
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const applyRename = useCallback((args) => {
        renameDrgElement({
            ...args,
            index,
            externalDmnModelsByNamespaceMap,
        });
    }, [externalDmnModelsByNamespaceMap, index]);
    const setNewIdentifierNameCandidate = useCallback((name) => {
        if (name === oldName) {
            return;
        }
        dmnEditorStoreApi.setState((state) => {
            if (isIdentifierReferencedInSomeExpression({
                identifierUuid: identifierId,
                dmnDefinitions: state.dmn.model.definitions,
                externalDmnModelsByNamespaceMap,
            })) {
                setNewName(name);
                setIsRefactorModalOpen(true);
            }
            else {
                applyRename({
                    definitions: state.dmn.model.definitions,
                    newName: name,
                    shouldRenameReferencedExpressions: false,
                });
            }
        });
    }, [oldName, dmnEditorStoreApi, identifierId, externalDmnModelsByNamespaceMap, applyRename]);
    const refactorConfirmationDialog = useMemo(() => (_jsx(RefactorConfirmationDialog, { onConfirmExpressionRefactor: () => {
            setIsRefactorModalOpen(false);
            dmnEditorStoreApi.setState((state) => {
                applyRename({
                    definitions: state.dmn.model.definitions,
                    newName,
                    shouldRenameReferencedExpressions: true,
                });
            });
        }, onConfirmRenameOnly: () => {
            setIsRefactorModalOpen(false);
            dmnEditorStoreApi.setState((state) => {
                applyRename({
                    definitions: state.dmn.model.definitions,
                    newName,
                    shouldRenameReferencedExpressions: false,
                });
            });
        }, onCancel: () => {
            setIsRefactorModalOpen(false);
            setNewName("");
        }, isRefactorModalOpen: isRefactorModalOpen, fromName: oldName, toName: newName })), [applyRename, dmnEditorStoreApi, isRefactorModalOpen, newName, oldName]);
    return {
        setNewIdentifierNameCandidate,
        isRefactorModalOpen,
        setIsRefactorModalOpen,
        refactorConfirmationDialog,
        newName,
    };
}
//# sourceMappingURL=RefactorConfirmationDialog.js.map