import { parseXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { KIE_DMN_UNKNOWN_NAMESPACE } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
export function computeIndexedDrd(thisDmnsNamespace, definitions, drdIndex) {
    var _a, _b, _c, _d, _e;
    const dmnEdgesByDmnElementRef = new Map();
    const dmnShapesByHref = new Map();
    const hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects = new Set();
    const diagramElements = (_d = (_c = (_b = (_a = definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[drdIndex]) === null || _c === void 0 ? void 0 : _c["dmndi:DMNDiagramElement"]) !== null && _d !== void 0 ? _d : [];
    for (let i = 0; i < diagramElements.length; i++) {
        const e = diagramElements[i];
        if (e.__$$element === "dmndi:DMNEdge") {
            dmnEdgesByDmnElementRef.set(e["@_dmnElementRef"], { ...e, index: i });
        }
        else if (e.__$$element === "dmndi:DMNShape") {
            let href;
            const dmnElementRefQName = parseXmlQName(e["@_dmnElementRef"]);
            if (dmnElementRefQName.prefix) {
                const namespace = (_e = definitions[`@_xmlns:${dmnElementRefQName.prefix}`]) !== null && _e !== void 0 ? _e : KIE_DMN_UNKNOWN_NAMESPACE;
                href = buildXmlHref({ namespace, id: dmnElementRefQName.localPart });
                hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects.add(href);
            }
            else {
                href = buildXmlHref({
                    namespace: definitions["@_namespace"] === thisDmnsNamespace ? "" : definitions["@_namespace"],
                    id: dmnElementRefQName.localPart,
                });
            }
            dmnShapesByHref.set(href, { ...e, index: i, dmnElementRefQName });
        }
        else {
        }
    }
    return {
        dmnEdgesByDmnElementRef,
        dmnShapesByHref,
        hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects,
    };
}
//# sourceMappingURL=computeIndexes.js.map