import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import React, { useMemo } from "react";
import { useImperativeHandle, useState } from "react";
import JobsManagement from "./components/JobsManagement/JobsManagement";
import JobsManagementEnvelopeViewDriver from "./JobsManagementEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
import { JobStatus } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { OrderBy } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const defaultStatus = [JobStatus.Scheduled];
const defaultOrderBy = {
    lastUpdate: OrderBy.DESC,
};
export const JobsManagementEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [jobsManagementInitArgs, setJobsManagementInitArgs] = useState({
        initialState: {
            filters: defaultStatus,
            orderBy: defaultOrderBy,
        },
    });
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const driver = useMemo(() => new JobsManagementEnvelopeViewDriver(props.channelApi), [props.channelApi]);
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setEnvelopeConnectedToChannel(false);
            setJobsManagementInitArgs(initArgs);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(_Fragment, { children: _jsx(JobsManagement, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, initialState: jobsManagementInitArgs.initialState, driver: driver }) }));
});
export default JobsManagementEnvelopeView;
//# sourceMappingURL=JobsManagementEnvelopeView.js.map