import React from "react";
import { ISortBy } from "@patternfly/react-table/dist/js/components/Table";
import { Job, JobsSortBy } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { JobsManagementDriver } from "../../../api";
import "../styles.css";
import { OUIAProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
interface JobsManagementTableProps {
    jobs: Job[];
    driver: JobsManagementDriver;
    doQueryJobs: (offset: number, limit: number) => Promise<void>;
    handleCancelModalToggle: () => void;
    handleDetailsToggle: () => void;
    handleRescheduleToggle: () => void;
    isActionPerformed: boolean;
    isLoading: boolean;
    setIsActionPerformed: (isActionPerformed: boolean) => void;
    selectedJobInstances: Job[];
    setModalTitle: (title: JSX.Element) => void;
    setModalContent: (content: string) => void;
    setSelectedJobInstances: React.Dispatch<React.SetStateAction<Job[]>>;
    setSelectedJob: (job?: Job) => void;
    setSortBy: (sortObj: ISortBy) => void;
    setOrderBy: (orderBy: JobsSortBy) => void;
    sortBy: ISortBy;
}
declare const JobsManagementTable: React.FC<JobsManagementTableProps & OUIAProps>;
export default JobsManagementTable;
//# sourceMappingURL=JobsManagementTable.d.ts.map