import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import React, { useCallback, useMemo } from "react";
import { Modal, ModalVariant, ModalBoxBody } from "@patternfly/react-core/dist/js/components/Modal";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { OutlinedClockIcon } from "@patternfly/react-icons/dist/js/icons/outlined-clock-icon";
import DateTimePicker from "react-datetime-picker";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
export const JobsRescheduleModal = ({ job, actionType, modalAction, isModalOpen, handleModalToggle, rescheduleError, setRescheduleError, handleJobReschedule, ouiaId, ouiaSafe, }) => {
    const [scheduleDate, setScheduleDate] = React.useState(new Date(job.expirationTime));
    const [repeatInterval, setRepeatInterval] = React.useState(job.repeatInterval);
    const [repeatLimit, setRepeatLimit] = React.useState(job.repeatLimit);
    const [errorModalOpen, setErrorModalOpen] = React.useState(false);
    const handleIntervalChange = useCallback((value) => {
        setRepeatInterval(value);
    }, []);
    const handleLimitChange = useCallback((value) => {
        setRepeatLimit(value);
    }, []);
    const handleDateChange = useCallback((value) => {
        setScheduleDate(value);
    }, []);
    const handleTimeNow = useCallback(() => {
        setScheduleDate(new Date());
    }, []);
    const onApplyReschedule = useCallback(() => {
        handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate);
    }, [handleJobReschedule, job, repeatInterval, repeatLimit, scheduleDate]);
    const applyAction = useMemo(() => [
        _jsx(Button, { variant: "primary", id: "apply-button", onClick: onApplyReschedule, children: "Apply" }, "apply-selection"),
    ], [onApplyReschedule]);
    const handleErrorModal = useCallback(() => {
        setErrorModalOpen((currentErrorModalOpen) => !currentErrorModalOpen);
    }, []);
    const errorModalAction = [
        _jsx(Button, { variant: "primary", onClick: () => {
                handleErrorModal();
                setRescheduleError("");
            }, children: "OK" }, "confirm-selection"),
    ];
    React.useEffect(() => {
        rescheduleError.length > 0 && handleErrorModal();
    }, [handleErrorModal, rescheduleError]);
    return (_jsxs(_Fragment, { children: [_jsx(Modal, { variant: ModalVariant.small, "aria-labelledby": "actionType" + " modal", "aria-label": actionType + " modal", title: "", header: setTitle("success", "Job Reschedule"), isOpen: isModalOpen, onClose: handleModalToggle, actions: [...applyAction, ...modalAction], ...componentOuiaProps(ouiaId, "job-reschedule-modal", ouiaSafe), children: _jsx(ModalBoxBody, { className: "kogito-management-console-shared--jobsModal__ModalBody", children: _jsxs(Form, { isHorizontal: true, children: [_jsxs(FormGroup, { label: "Expiration Time", fieldId: "horizontal-form-name", children: [scheduleDate && scheduleDate !== undefined && (_jsx(DateTimePicker, { value: scheduleDate, minDate: new Date(), onChange: handleDateChange })), _jsxs(Button, { className: "kogito-management-console-shared--jobsModal__TimeNow", id: "Time-now", onClick: handleTimeNow, children: [_jsx(OutlinedClockIcon, {}), " Now"] })] }), _jsx(FormGroup, { label: "Repeat Interval", fieldId: "repeat-interval", helperText: repeatInterval === null ? "Input disabled since it is an one-time run job" : null, children: _jsx(TextInput, { type: "text", id: "repeat-interval-input", name: "repeat-interval-input", "aria-describedby": "repeat-interval", value: repeatInterval || "", onChange: handleIntervalChange, isDisabled: repeatInterval === null }) }), _jsx(FormGroup, { label: "Repeat Limit", fieldId: "repeat-limit", helperText: repeatLimit === null ? "Input disabled since it is an one-time run job" : null, children: _jsx(TextInput, { type: "text", id: "repeat-limit-input", name: "repeat-limit-input", "aria-describedby": "repeat-limit", value: repeatLimit || "", onChange: handleLimitChange, isDisabled: repeatLimit === null }) })] }) }) }), _jsx(Modal, { variant: ModalVariant.small, "aria-labelledby": "Reschedule error modal", "aria-label": "Reschedule error modal", title: "", header: setTitle("failure", "Job Reschedule"), isOpen: errorModalOpen, onClose: handleErrorModal, actions: errorModalAction, ...componentOuiaProps(ouiaId, "job-reschedule-error-modal", ouiaSafe), children: _jsx(Button, { variant: "primary", onClick: () => {
                        handleErrorModal();
                        setRescheduleError("");
                    }, children: "OK" }, "confirm-selection") })] }));
};
//# sourceMappingURL=JobsRescheduleModal.js.map