import { jsx as _jsx } from "react/jsx-runtime";
import { Modal, ModalVariant, ModalBoxBody } from "@patternfly/react-core/dist/js/components/Modal";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessDetailsErrorModal = ({ errorString, errorModalOpen, errorModalAction, handleErrorModal, label, title, ouiaId, ouiaSafe, }) => {
    const errorModalContent = () => {
        return (_jsx(ModalBoxBody, { children: _jsx(TextContent, { children: _jsx(Text, { children: errorString }) }) }));
    };
    return (_jsx(Modal, { variant: ModalVariant.small, "aria-labelledby": label, "aria-label": label, title: "", header: title, isOpen: errorModalOpen, onClose: handleErrorModal, actions: errorModalAction, ...componentOuiaProps(ouiaId, "process-details-error-modal", ouiaSafe), children: errorModalContent() }));
};
export default ProcessDetailsErrorModal;
//# sourceMappingURL=ProcessDetailsErrorModal.js.map