import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Dropdown, DropdownToggle, DropdownItem } from "@patternfly/react-core/dist/js/components/Dropdown";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { useState, useEffect, useMemo, useCallback } from "react";
import { CaretDownIcon } from "@patternfly/react-icons/dist/js/icons/caret-down-icon";
import ProcessDetailsErrorModal from "../ProcessDetailsErrorModal/ProcessDetailsErrorModal";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
const BANNED_NODE_TYPES = ["BoundaryEventNode", "EndNode", "Join", "StartNode", "Split"];
const ProcessDetailsNodeTrigger = ({ processInstanceData, driver, ouiaId, ouiaSafe, }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [selectedNode, setSelectedNode] = useState();
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [isError, setIsError] = useState(false);
    const [nodes, setNodes] = useState([]);
    useEffect(() => {
        (async () => {
            await driver
                .getTriggerableNodes(processInstanceData)
                .then((nodeInstances) => {
                setIsError(false);
                setNodes(nodeInstances);
            })
                .catch((error) => {
                setIsError(true);
                setModalTitle("Node trigger Error");
                setModalContent(`Retrieval of nodes failed with error: ${error.message}`);
                setTitleType("failure");
                handleModalToggle();
            });
        })();
    }, []);
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const onSelect = (event) => {
        setIsOpen(!isOpen);
        getSelectedNode(event.currentTarget.id);
    };
    const onToggle = (isDropDownOpen) => {
        setIsOpen(isDropDownOpen);
    };
    const getSelectedNode = useCallback((selectedNodeId) => {
        setSelectedNode(nodes.find((node) => node.id === selectedNodeId));
    }, [nodes]);
    const nodeDropDownOptions = useMemo(() => {
        return nodes
            .filter((node) => {
            return node.type !== null && !BANNED_NODE_TYPES.includes(node.type);
        })
            .map((node) => (_jsx(DropdownItem, { id: node.id, children: node.name }, node.id)));
    }, [nodes]);
    const onTriggerClick = () => {
        setModalTitle("Node trigger process");
        driver
            .handleNodeTrigger(processInstanceData, selectedNode)
            .then(() => {
            setTitleType("success");
            setModalContent(`The node ${selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.name} was triggered successfully`);
        })
            .catch((error) => {
            setTitleType("failure");
            setModalContent(`The node ${selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.name} trigger failed. ErrorMessage : ${error.message}`);
        })
            .finally(() => {
            handleModalToggle();
        });
    };
    const errorModalAction = [
        _jsx(Button, { variant: "primary", onClick: handleModalToggle, children: "OK" }, "confirm-selection"),
    ];
    return (_jsxs(_Fragment, { children: [_jsx(ProcessDetailsErrorModal, { errorString: modalContent, errorModalOpen: isModalOpen, errorModalAction: errorModalAction, handleErrorModal: handleModalToggle, label: "Node Trigger Error", title: setTitle(titleType, modalTitle) }), !isError ? (_jsxs(Card, { ...componentOuiaProps(ouiaId, "node-trigger", ouiaSafe), children: [_jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Node Trigger" }) }), _jsx(CardHeader, { children: _jsx("div", { children: "Select a node from the process nodes list and click Trigger to launch it manually." }) }), _jsxs(CardBody, { children: [_jsx("div", { children: _jsx(Dropdown, { direction: "up", onSelect: onSelect, toggle: _jsx(DropdownToggle, { id: "toggle-id", "data-testid": "toggle-id", onToggle: onToggle, toggleIndicator: CaretDownIcon, children: selectedNode ? selectedNode.name : "select a node" }), isOpen: isOpen, dropdownItems: nodeDropDownOptions }) }), selectedNode && (_jsx(_Fragment, { children: _jsx("div", { className: "pf-u-mt-md", children: _jsxs(Flex, { direction: { default: "column" }, children: [_jsx(FlexItem, { children: _jsxs(TextContent, { children: [" ", _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node name : " }) }), _jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.p, children: selectedNode.name }) })] })] }) }), _jsx(FlexItem, { children: _jsxs(TextContent, { children: [" ", _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node type : " }) }), _jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.p, children: selectedNode.type }) })] })] }) }), _jsx(FlexItem, { children: _jsxs(TextContent, { children: [" ", _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node id : " }) }), _jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.p, children: selectedNode.id }) })] })] }) })] }) }) })), _jsx("div", { className: "pf-u-mt-md", children: _jsx(Button, { variant: "secondary", onClick: onTriggerClick, id: "trigger", "data-testid": "trigger", isDisabled: !selectedNode, children: "Trigger" }) })] })] })) : (_jsx(_Fragment, {}))] }));
};
export default ProcessDetailsNodeTrigger;
//# sourceMappingURL=ProcessDetailsNodeTrigger.js.map