import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import Moment from "react-moment";
import { Dropdown, KebabToggle, DropdownItem } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Stack } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { UserIcon } from "@patternfly/react-icons/dist/js/icons/user-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { OutlinedClockIcon } from "@patternfly/react-icons/dist/js/icons/outlined-clock-icon";
import { useCallback, useState } from "react";
import "../styles.css";
import { handleJobRescheduleUtil, handleNodeInstanceCancel, handleNodeInstanceRetrigger, handleRetry, handleSkip, jobCancel, } from "../../../utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { JobsDetailsModal } from "../../../../jobsManagement/envelope/components/JobsDetailsModal";
import { JobsRescheduleModal } from "../../../../jobsManagement/envelope/components/JobsRescheduleModal";
import { JobsCancelModal } from "../../../../jobsManagement/envelope/components/JobsCancelModal";
var TitleType;
(function (TitleType) {
    TitleType["SUCCESS"] = "success";
    TitleType["FAILURE"] = "failure";
})(TitleType || (TitleType = {}));
const ProcessDetailsTimelinePanel = ({ data, jobs, driver, omittedProcessTimelineEvents, ouiaId, ouiaSafe, }) => {
    const [kebabOpenArray, setKebabOpenArray] = useState([]);
    const [modalTitle, setModalTitle] = useState();
    const setCancelModalTitle = () => {
        return null;
    };
    const [modalContent, setModalContent] = useState("");
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [isDetailsModalOpen, setIsDetailsModalOpen] = useState(false);
    const [isRescheduleModalOpen, setIsRescheduleModalOpen] = useState(false);
    const [isCancelModalOpen, setIsCancelModalOpen] = useState(false);
    const [selectedJob, setSelectedJob] = useState({});
    const ignoredNodeTypes = ["Join", "Split", "EndNode"];
    const editableJobStatus = ["SCHEDULED", "ERROR"];
    const [rescheduleError, setRescheduleError] = useState("");
    const onKebabToggle = (isOpen, id) => {
        if (isOpen) {
            setKebabOpenArray([...kebabOpenArray, id]);
        }
        else {
            onDropdownSelect(id);
        }
    };
    const onDropdownSelect = (id) => {
        const tempKebabArray = [...kebabOpenArray];
        const index = tempKebabArray.indexOf(id);
        tempKebabArray.splice(index, 1);
        setKebabOpenArray(tempKebabArray);
    };
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const handleJobDetailsModalToggle = () => {
        setIsDetailsModalOpen(!isDetailsModalOpen);
    };
    const onShowMessage = (title, content, type) => {
        setModalTitle(setTitle(type, title));
        setModalContent(content);
        handleModalToggle();
    };
    const handleJobDetails = (job) => {
        setSelectedJob(job);
        handleDetailsToggle();
    };
    const handleDetailsToggle = () => {
        setIsDetailsModalOpen(!isDetailsModalOpen);
    };
    const handleJobRescheduleBySelected = (job) => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
        setSelectedJob(job);
    };
    const handleJobReschedule = async (_job, repeatInterval, repeatLimit, scheduleDate) => {
        await handleJobRescheduleUtil(repeatInterval, repeatLimit, scheduleDate, selectedJob, handleRescheduleAction, driver, setRescheduleError);
    };
    const handleCancelAction = async (job) => {
        await jobCancel(driver, job, setCancelModalTitle, setModalContent);
        handleCancelModalToggle();
    };
    const handleCancelModalToggle = () => {
        setIsCancelModalOpen(!isCancelModalOpen);
    };
    const renderJobActions = (id, options) => {
        if (jobs.length > 0) {
            return jobs.map((job) => {
                if (id === job.nodeInstanceId && editableJobStatus.includes(job.status)) {
                    return [
                        ...options,
                        _jsx(DropdownItem, { "data-testid": "job-details", id: "job-details", component: "button", onClick: () => handleJobDetails(job), children: "Job Details" }, "job-details"),
                        _jsx(DropdownItem, { "data-testid": "job-reschedule", id: "job-reschedule", component: "button", onClick: () => handleJobRescheduleBySelected(job), children: "Job Reschedule" }, "job-reschedule"),
                        _jsx(DropdownItem, { "data-testid": "job-cancel", id: "job-cancel", component: "button", onClick: () => handleCancelAction(job), children: "Job Cancel" }, "job-cancel"),
                    ];
                }
                else if (id === job.nodeInstanceId && !editableJobStatus.includes(job.status)) {
                    return [
                        ...options,
                        _jsx(DropdownItem, { id: "job-details", component: "button", onClick: () => handleJobDetails(job), children: "Job Details" }, "job-details"),
                    ];
                }
                else {
                    return [];
                }
            });
        }
        else {
            return options;
        }
    };
    const dropdownItems = (processInstanceData, node) => {
        if (processInstanceData.error && node.definitionId === processInstanceData.error.nodeDefinitionId) {
            const options = [
                _jsx(DropdownItem, { "data-testid": "retry", component: "button", onClick: () => handleRetry(processInstanceData, driver, () => onShowMessage("Retry operation", `The node ${node.name} was successfully re-executed.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Retry operation", `The node ${node.name} failed to re-execute. Message: ${errorMessage}`, TitleType.FAILURE)), children: "Retry" }, "retry"),
                _jsx(DropdownItem, { "data-testid": "skip", component: "button", onClick: () => handleSkip(processInstanceData, driver, () => onShowMessage("Skip operation", `The node ${node.name} was successfully skipped.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Skip operation", `The node ${node.name} failed to skip. Message: ${errorMessage}`, TitleType.FAILURE)), children: "Skip" }, "skip"),
            ];
            const items = renderJobActions(node.id, options);
            return items.flat();
        }
        else if (node.exit === null && !ignoredNodeTypes.includes(node.type)) {
            const options = [
                _jsx(DropdownItem, { "data-testid": "retrigger", component: "button", onClick: () => handleNodeInstanceRetrigger(processInstanceData, driver, node, () => onShowMessage("Node retrigger operation", `The node ${node.name} was successfully retriggered.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Node retrigger operation", `The node ${node.name} failed to retrigger. Message: ${errorMessage}`, TitleType.FAILURE)), children: "Retrigger node" }, "retrigger"),
                _jsx(DropdownItem, { "data-testid": "cancel", component: "button", onClick: () => handleNodeInstanceCancel(processInstanceData, driver, node, () => onShowMessage("Node cancel operation", `The node ${node.name} was successfully canceled.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Node cancel operation", `The node ${node.name} failed to cancel. Message: ${errorMessage}`, TitleType.FAILURE)), children: "Cancel node" }, "cancel"),
            ];
            const items = renderJobActions(node.id, options);
            return items.flat();
        }
        else {
            const items = renderJobActions(node.id, []);
            return items.flat();
        }
    };
    const processManagementKebabButtons = (node, index) => {
        var _a;
        const dropdownItemsValue = dropdownItems(data, node);
        if (((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
            data.serviceUrl !== null &&
            dropdownItemsValue &&
            dropdownItemsValue.length !== 0) {
            return (_jsx(Dropdown, { onSelect: () => onDropdownSelect("timeline-kebab-toggle-" + index), toggle: _jsx(KebabToggle, { onToggle: (isOpen) => onKebabToggle(isOpen, "timeline-kebab-toggle-" + index), id: "timeline-kebab-toggle-" + index, "data-testid": "timeline-kebab-toggle-" + index }), position: "right", isOpen: kebabOpenArray.includes("timeline-kebab-toggle-" + index), isPlain: true, dropdownItems: dropdownItemsValue }));
        }
    };
    const renderTimerIcon = (id) => {
        const job = jobs.find((job) => id === job.nodeInstanceId);
        if (job) {
            return (_jsx(Tooltip, { content: "Node has job", children: _jsx(OutlinedClockIcon, { className: "pf-u-ml-sm", color: "var(--pf-global--icon--Color--dark)", onClick: () => handleJobDetails(job) }) }, `${id}-job-tooltip-${job.id}`));
        }
        return _jsx(_Fragment, {});
    };
    const detailsAction = [
        _jsx(Button, { variant: "primary", onClick: handleModalToggle, children: "OK" }, "confirm-selection"),
    ];
    const handleRescheduleAction = () => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
    };
    const rescheduleActions = [
        _jsx(Button, { variant: "secondary", onClick: handleRescheduleAction, children: "Cancel" }, "cancel-reschedule"),
    ];
    const compareNodes = useCallback((nodeA, nodeB) => {
        if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.enter) < (nodeB === null || nodeB === void 0 ? void 0 : nodeB.enter)) {
            return -1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.enter) > (nodeB === null || nodeB === void 0 ? void 0 : nodeB.enter)) {
            return 1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.exit) < (nodeB === null || nodeB === void 0 ? void 0 : nodeB.exit)) {
            return -1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.exit) > (nodeB === null || nodeB === void 0 ? void 0 : nodeB.exit)) {
            return 1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.id) < (nodeB === null || nodeB === void 0 ? void 0 : nodeB.id)) {
            return -1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.id) > (nodeB === null || nodeB === void 0 ? void 0 : nodeB.id)) {
            return 1;
        }
        return 0;
    }, []);
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId ? ouiaId : data.id, "timeline", ouiaSafe), children: [_jsx(ProcessInfoModal, { isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalTitle: modalTitle, modalContent: modalContent }), _jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Timeline" }) }), _jsx(CardBody, { children: _jsx(Stack, { hasGutter: true, className: "kogito-process-details--timeline", children: data.nodes &&
                        data.nodes
                            .filter((content) => !(omittedProcessTimelineEvents === null || omittedProcessTimelineEvents === void 0 ? void 0 : omittedProcessTimelineEvents.includes(content.name)))
                            .sort(compareNodes)
                            .map((content, idx) => {
                            return (_jsxs(Split, { hasGutter: true, className: "kogito-process-details--timeline-item", children: [_jsx(SplitItem, { children: _jsx(_Fragment, { children: data.error && content.definitionId === data.error.nodeDefinitionId ? (_jsx(Tooltip, { content: data.error.message, children: _jsx(ErrorCircleOIcon, { color: "var(--pf-global--danger-color--100)", className: "kogito-process-details--timeline-status" }) })) : content.exit === null ? (_jsx(Tooltip, { content: "Active", children: _jsx(OnRunningIcon, { className: "kogito-process-details--timeline-status" }) })) : (_jsx(Tooltip, { content: "Completed", children: _jsx(CheckCircleIcon, { color: "var(--pf-global--success-color--100)", className: "kogito-process-details--timeline-status" }) })) }) }), _jsx(SplitItem, { isFilled: true, children: _jsx(TextContent, { children: _jsxs(Text, { component: TextVariants.p, children: [content.name, _jsxs("span", { children: [content.type === "HumanTaskNode" && (_jsx(Tooltip, { content: "User Task", children: _jsx(UserIcon, { className: "pf-u-ml-sm", color: "var(--pf-global--icon--Color--light)" }) })), renderTimerIcon(content.id)] }), _jsx(Text, { component: TextVariants.small, children: content.exit === null ? "Active" : _jsx(Moment, { fromNow: true, children: new Date(`${content.exit}`) }) })] }) }) }), _jsx(SplitItem, { children: processManagementKebabButtons(content, idx) })] }, content.id));
                        }) }) }), _jsx(JobsDetailsModal, { actionType: "Job Details", modalTitle: setTitle("success", "Job Details"), isModalOpen: isDetailsModalOpen, handleModalToggle: handleJobDetailsModalToggle, modalAction: detailsAction, job: selectedJob }), Object.keys(selectedJob).length > 0 && (_jsx(JobsRescheduleModal, { actionType: "Job Reschedule", isModalOpen: isRescheduleModalOpen, handleModalToggle: handleRescheduleAction, modalAction: rescheduleActions, job: selectedJob, rescheduleError: rescheduleError, setRescheduleError: setRescheduleError, handleJobReschedule: handleJobReschedule })), _jsx(JobsCancelModal, { actionType: "Job Cancel", isModalOpen: isCancelModalOpen, handleModalToggle: handleCancelModalToggle, modalTitle: modalTitle, modalContent: modalContent })] }));
};
export default ProcessDetailsTimelinePanel;
//# sourceMappingURL=ProcessDetailsTimelinePanel.js.map