import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import { TaskFormEnvelopeView } from "./TaskFormEnvelopeView";
import { TaskFormEnvelopeApiImpl } from "./TaskFormEnvelopeApiImpl";
import "./styles.css";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            args.container.className = "kogito-task-form-container";
            ReactDOM.render(_jsx(TaskFormEnvelopeView, { ref: ref, channelApi: envelope.channelApi, targetOrigin: args.targetOrigin }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new TaskFormEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=TaskFormEnvelope.js.map