export class TaskInboxEnvelopeApiImpl {
    constructor(args) {
        this.args = args;
        this.capturedInitRequestYet = false;
        this.taskInbox__init = async (association, initArgs) => {
            this.args.envelopeClient.associate(association.origin, association.envelopeServerId);
            if (this.hasCapturedInitRequestYet()) {
                return;
            }
            this.view = await this.args.viewDelegate();
            this.ackCapturedInitRequest();
            this.view().initialize(initArgs.initialState, initArgs.allTaskStates, initArgs.activeTaskStates);
        };
        this.taskInbox__notify = (userName) => {
            this.view().notify(userName);
            return Promise.resolve();
        };
    }
    hasCapturedInitRequestYet() {
        return this.capturedInitRequestYet;
    }
    ackCapturedInitRequest() {
        this.capturedInitRequestYet = true;
    }
}
//# sourceMappingURL=TaskInboxEnvelopeApiImpl.js.map