import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import _ from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { LoadMore } from "@kie-tools/runtime-tools-components/dist/components/LoadMore";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
import TaskInboxToolbar from "../TaskInboxToolbar/TaskInboxToolbar";
import { getDateColumn, getDefaultColumn, getTaskDescriptionColumn, getTaskStateColumn } from "../utils/TaskInboxUtils";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
const UserTaskLoadingComponent = (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading user tasks...", ouiaId: "tasks-loading-tasks" }) }));
const TaskInbox = ({ isEnvelopeConnectedToChannel, initialState, driver, allTaskStates, activeTaskStates, currentUser, ouiaId, ouiaSafe, }) => {
    const [queryFilter, setQueryFilter] = useState({
        taskStates: [],
        taskNames: [],
    });
    const [allStates, setAllStates] = useState([]);
    const [activeStates, setActiveStates] = useState([]);
    const [sortBy, setSortBy] = useState({
        property: "lastUpdate",
        direction: "desc",
    });
    const [pageSize] = useState(10);
    const [isLoading, setIsLoading] = useState(true);
    const [isLoadingMore, setIsLoadingMore] = useState(false);
    const [offset, setOffset] = useState(0);
    const [error, setError] = useState(undefined);
    const [showEmptyFiltersError, setShowEmptyFiltersError] = useState(false);
    const [tasks, setTasks] = useState([]);
    const columns = useMemo(() => [
        getTaskDescriptionColumn((task) => driver.openTask(task)),
        getDefaultColumn("processId", "Process", true),
        getDefaultColumn("priority", "Priority", true),
        getTaskStateColumn(),
        getDateColumn("started", "Started"),
        getDateColumn("lastUpdate", "Last update"),
    ], [driver]);
    const getTableSortBy = useCallback(() => {
        return {
            index: columns.findIndex((column) => column.path === sortBy.property),
            direction: sortBy.direction,
        };
    }, [columns, sortBy.direction, sortBy.property]);
    const doQueryTasks = useCallback(async (_offset, _limit, _resetTasks, _resetPagination = false, _loadMore = false) => {
        setIsLoadingMore(_loadMore);
        setIsLoading(true);
        setError(null);
        try {
            const response = await driver.query(_offset, _limit);
            if (_resetTasks) {
                setTasks(response);
            }
            else {
                setTasks((currentTasks) => currentTasks.concat(response));
            }
            if (_resetPagination) {
                setOffset(_offset);
            }
        }
        catch (err) {
            setError(err);
        }
        finally {
            setIsLoading(false);
            setIsLoadingMore(false);
        }
    }, [driver]);
    const initDefault = useCallback((canceled) => {
        const defaultState = {
            filters: {
                taskStates: [...(activeTaskStates !== null && activeTaskStates !== void 0 ? activeTaskStates : [])],
                taskNames: [],
            },
            sortBy,
            currentPage: { offset: 0, limit: 10 },
        };
        return driver
            .setInitialState(defaultState)
            .then(() => {
            if (canceled.get()) {
                return;
            }
            setQueryFilter(defaultState.filters);
            setSortBy(defaultState.sortBy);
            return doQueryTasks(0, pageSize, true);
        })
            .then(() => {
            if (canceled.get()) {
                return;
            }
            setIsLoading(false);
        });
    }, [activeTaskStates, doQueryTasks, driver, pageSize, sortBy]);
    const initWithState = useCallback((canceled, initialState) => {
        setQueryFilter(initialState.filters);
        setSortBy(initialState.sortBy);
        setOffset(initialState.currentPage.offset);
        const limit = initialState.currentPage.offset + pageSize;
        return driver
            .setInitialState(initialState)
            .then(() => {
            if (canceled.get()) {
                return;
            }
            return doQueryTasks(0, limit, true);
        })
            .then(() => {
            if (canceled.get()) {
                return;
            }
            setIsLoading(false);
        });
    }, [doQueryTasks, driver, pageSize]);
    const doApplyFilter = useCallback(async (filter) => {
        setQueryFilter(filter);
        if (!filter || (_.isEmpty(filter.taskStates) && _.isEmpty(filter.taskNames))) {
            setShowEmptyFiltersError(true);
            return;
        }
        setShowEmptyFiltersError(false);
        setIsLoading(true);
        await driver.applyFilter(filter);
        doQueryTasks(0, pageSize, true, true);
    }, [doQueryTasks, driver, pageSize]);
    const doRefresh = useCallback(async () => {
        setIsLoading(true);
        doQueryTasks(0, pageSize, true, true);
    }, [doQueryTasks, pageSize]);
    const onSort = useCallback(async (index, direction) => {
        const sortObj = {
            property: columns[index].path,
            direction: direction.toLowerCase(),
        };
        await driver.applySorting(sortObj);
        setSortBy(sortObj);
        setIsLoading(true);
        await doQueryTasks(0, pageSize, true, true);
    }, [columns, doQueryTasks, driver, pageSize]);
    useCancelableEffect(useCallback(({ canceled }) => {
        if (isEnvelopeConnectedToChannel && currentUser && currentUser.length > 0) {
            initDefault(canceled);
        }
    }, [currentUser, initDefault, isEnvelopeConnectedToChannel]));
    useCancelableEffect(useCallback(({ canceled }) => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        else {
            setAllStates(allTaskStates !== null && allTaskStates !== void 0 ? allTaskStates : []);
            setActiveStates(activeTaskStates !== null && activeTaskStates !== void 0 ? activeTaskStates : []);
            if (!initialState) {
                initDefault(canceled);
            }
            else {
                initWithState(canceled, initialState);
            }
        }
    }, [activeTaskStates, allTaskStates, initDefault, initWithState, initialState, isEnvelopeConnectedToChannel]));
    const mustShowMore = useCallback(() => {
        if (!isLoadingMore) {
            const limit = offset * pageSize + pageSize;
            return !isLoading && limit === tasks.length;
        }
        return true;
    }, [isLoading, isLoadingMore, offset, pageSize, tasks.length]);
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "tasks", ouiaSafe), children: [_jsx(TaskInboxToolbar, { activeFilter: queryFilter, allTaskStates: allStates, activeTaskStates: activeStates, applyFilter: doApplyFilter, refresh: doRefresh }), showEmptyFiltersError ? (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Reset, title: "No status is selected", body: "Try selecting at least one status to see results", onClick: () => doApplyFilter({ taskStates: activeStates, taskNames: [] }), ouiaId: "tasks-no-status" })) : (_jsxs(_Fragment, { children: [_jsx(DataTable, { data: tasks, isLoading: isLoading, columns: columns, error: false, sortBy: getTableSortBy(), onSorting: onSort, LoadingComponent: UserTaskLoadingComponent }), mustShowMore() && (_jsx(LoadMore, { offset: offset, setOffset: setOffset, getMoreItems: (_offset, _limit) => doQueryTasks(_offset, _limit, false, true, true), pageSize: pageSize, isLoadingMore: isLoadingMore }))] }))] }));
};
export default TaskInbox;
//# sourceMappingURL=TaskInbox.js.map