import { Fragment as _Fragment, jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useEffect, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Table, TableHeader, TableBody, sortable, } from "@patternfly/react-table/dist/js/components/Table";
import isEmpty from "lodash/isEmpty";
import filter from "lodash/filter";
import get from "lodash/get";
import sample from "lodash/sample";
import keys from "lodash/keys";
import reduce from "lodash/reduce";
import isFunction from "lodash/isFunction";
import { v4 as uuidv4 } from "uuid";
import { componentOuiaProps } from "../../ouiaTools";
import { KogitoSpinner } from "../KogitoSpinner/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType } from "../KogitoEmptyState/KogitoEmptyState";
const getCellData = (dataObj, path) => {
    var _a;
    if (dataObj && path) {
        return (_a = get(dataObj, path)) !== null && _a !== void 0 ? _a : "N/A";
    }
    else {
        return "N/A";
    }
};
const getColumns = (data, columns) => {
    if (data) {
        return columns
            ? filter(columns, (column) => !isEmpty(column.path)).map((column) => {
                return {
                    title: column.label,
                    data: column.path,
                    cellTransforms: column.bodyCellTransformer
                        ? [
                            ((value, extra) => {
                                const rowDataObj = data[extra.rowIndex];
                                return {
                                    children: column.bodyCellTransformer(value === null || value === void 0 ? void 0 : value.title, rowDataObj),
                                };
                            }),
                        ]
                        : undefined,
                    transforms: column.isSortable ? [sortable] : undefined,
                };
            })
            : filter(keys(sample(data)), (key) => key !== "__typename").map((key) => ({ title: key, data: key }));
    }
    else if (columns) {
        return filter(columns, (column) => !isEmpty(column.path)).map((column) => {
            return {
                title: column.label,
                data: column.path,
            };
        });
    }
    return [];
};
const getRows = (data, columns) => {
    let rowList = [];
    if (data) {
        rowList = data.map((rowData) => {
            return {
                cells: reduce(columns, (result, column) => {
                    if (column.data) {
                        result.push(getCellData(rowData, column.data));
                    }
                    return result;
                }, []),
                rowKey: uuidv4(),
            };
        });
    }
    return rowList;
};
export const DataTable = ({ data, isLoading, columns, error, LoadingComponent, ErrorComponent, sortBy, onSorting, ouiaId, ouiaSafe, }) => {
    const [rows, setRows] = useState([]);
    const [columnList, setColumnList] = useState([]);
    useEffect(() => {
        if (isLoading) {
            const cols = getColumns(undefined, columns);
            const row = [
                {
                    cells: [
                        {
                            props: { colSpan: cols.length },
                            title: LoadingComponent ? (_jsx(_Fragment, { children: LoadingComponent })) : (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading ..." }) })),
                        },
                    ],
                    rowKey: "0",
                },
            ];
            setColumnList(cols);
            setRows(row);
        }
        else if (isEmpty(data)) {
            const cols = getColumns(undefined, columns);
            const row = [
                {
                    cells: [
                        {
                            props: { colSpan: cols.length },
                            title: (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" })),
                        },
                    ],
                    rowKey: "0",
                },
            ];
            setColumnList(cols);
            setRows(row);
        }
        else {
            const cols = getColumns(data, columns);
            setColumnList(cols);
            setRows(getRows(data, cols));
        }
    }, [data, isLoading]);
    const onSort = (event, index, direction) => {
        if (isFunction(onSorting)) {
            onSorting(index, direction);
        }
    };
    if (error) {
        return ErrorComponent ? (_jsx(React.Fragment, { children: ErrorComponent })) : (_jsx("div", { className: ".pf-u-my-xl", children: _jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Refresh, title: "Oops... error while loading", body: "Try using the refresh action to reload" }) }));
    }
    return (_jsx(React.Fragment, { children: _jsxs(Table, { "aria-label": "Data Table", cells: columnList, rows: rows, sortBy: sortBy, onSort: onSort, ...componentOuiaProps(ouiaId, "data-table", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(TableHeader, {}), _jsx(TableBody, { rowKey: "rowKey" })] }) }));
};
//# sourceMappingURL=DataTable.js.map