import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useState } from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ClipboardCopy, ClipboardCopyVariant } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { componentOuiaProps } from "../../ouiaTools";
export const ServerErrors = ({ ouiaId, ouiaSafe, ...props }) => {
    const [displayError, setDisplayError] = useState(false);
    const getErrorSubTitle = () => {
        try {
            const errorObject = JSON.parse(props.error);
            if ((errorObject.networkError && errorObject.networkError.name) ||
                (errorObject.networkError &&
                    !errorObject.networkError.name &&
                    errorObject.graphQLErrors &&
                    !(errorObject.graphQLErrors.size > 0) &&
                    errorObject.message === "Network error: Failed to fetch")) {
                return "An error occurred while accessing data. It is possible the data index is still being loaded, please try again in a few moments.";
            }
            else {
                return "An error occurred while accessing data.";
            }
        }
        catch (error) {
            return "An error occurred while accessing data.";
        }
    };
    const getErrorContent = () => {
        try {
            const errorObject = typeof props.error === "string" ? JSON.parse(props.error) : props.error;
            return errorObject.networkError && errorObject.networkError.name
                ? JSON.stringify(errorObject.networkError)
                : errorObject.graphQLErrors && errorObject.graphQLErrors.size > 0
                    ? JSON.stringify(errorObject.graphQLErrors)
                    : errorObject.message
                        ? errorObject.message
                        : JSON.stringify(props.error);
        }
        catch (error) {
            return props.error;
        }
    };
    const renderContent = () => (_jsx(Bullseye, { ...componentOuiaProps(ouiaId, "server-errors", ouiaSafe), children: _jsxs(EmptyState, { variant: EmptyStateVariant.full, children: [_jsx(EmptyStateIcon, { icon: ExclamationCircleIcon, color: "var(--pf-global--danger-color--100)" }), _jsx(Title, { headingLevel: "h1", size: "4xl", children: "Error fetching data" }), _jsxs(EmptyStateBody, { children: [getErrorSubTitle(), " ", _jsx(Button, { variant: "link", isInline: true, id: "display-error", onClick: () => setDisplayError(!displayError), children: "See more details" })] }), displayError && (_jsx(EmptyStateBody, { children: _jsx(ClipboardCopy, { isCode: true, variant: ClipboardCopyVariant.expansion, isExpanded: true, className: "pf-u-text-align-left", children: getErrorContent() }) })), props.children] }) }));
    return (_jsxs(_Fragment, { children: [props.variant === "large" && _jsx(PageSection, { variant: "light", children: renderContent() }), props.variant === "small" && renderContent()] }));
};
//# sourceMappingURL=ServerErrors.js.map