export const ouiaPageTypeAndObjectId = (type, objectId) => {
    document.body.setAttribute("data-ouia-page-type", type);
    if (objectId) {
        document.body.setAttribute("data-ouia-page-object-id", objectId);
    }
    return () => {
        document.body.removeAttribute("data-ouia-page-type");
        if (objectId) {
            document.body.removeAttribute("data-ouia-page-object-id");
        }
    };
};
export const ouiaAttribute = (name, value) => {
    if (value) {
        return { [name]: value };
    }
    return {};
};
export const componentOuiaProps = (ouiaId, ouiaType, isSafe = true) => {
    return {
        ...(ouiaId && { "data-ouia-component-id": ouiaId }),
        "data-ouia-component-type": ouiaType,
        "data-ouia-safe": isSafe,
    };
};
export const attributeOuiaId = (ouiaId) => {
    return ouiaAttribute("data-ouia-component-id", ouiaId);
};
//# sourceMappingURL=OuiaUtils.js.map