"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNormalizedPosixPathRelativeToWorkspaceRoot = getNormalizedPosixPathRelativeToWorkspaceRoot;
exports.getWorkspaceRoot = getWorkspaceRoot;
var vscode = require("vscode");
var __path = require("path");
function getNormalizedPosixPathRelativeToWorkspaceRoot(document) {
    return vscode.workspace.workspaceFolders
        ? vscode.workspace.asRelativePath(document.uri, false)
        : __path.relative(__path.dirname(document.uri.path), document.uri.path);
}
function getWorkspaceRoot(document) {
    var _a;
    var workspaceFolder = (_a = vscode.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.find(function (wf) {
        return document.uri.fsPath.startsWith(wf.uri.fsPath);
    });
    if (workspaceFolder) {
        return {
            type: "workspace",
            workspaceRootAbsoluteFsPath: workspaceFolder.uri.fsPath,
        };
    }
    else {
        return {
            type: "dangling",
            workspaceRootAbsoluteFsPath: __path.dirname(document.uri.fsPath),
        };
    }
}
//# sourceMappingURL=workspaceRoot.js.map