import { AnomalyDetectionModel, AssociationModel, BaselineModel, BayesianNetworkModel, ClusteringModel, GaussianProcessModel, GeneralRegressionModel, MiningModel, NaiveBayesModel, NearestNeighborModel, NeuralNetwork, RegressionModel, RuleSetModel, Scorecard, SequenceModel, SupportVectorMachineModel, TextModel, TimeSeriesModel, TreeModel, } from "@kie-tools/pmml-editor-marshaller";
import { Builder } from "./paths";
import { get } from "lodash";
const ICON_BASE = "images/";
const ICON_DEFAULT = "card-icon-default.svg";
export var SupportedCapability;
(function (SupportedCapability) {
    SupportedCapability[SupportedCapability["NONE"] = 0] = "NONE";
    SupportedCapability[SupportedCapability["VIEWER"] = 1] = "VIEWER";
    SupportedCapability[SupportedCapability["EDITOR"] = 2] = "EDITOR";
})(SupportedCapability || (SupportedCapability = {}));
export const PMMLModels = new Array({
    model: AnomalyDetectionModel,
    type: "Anomaly Detection Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: AssociationModel,
    type: "Association Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: BayesianNetworkModel,
    type: "Bayesian Network Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: BaselineModel,
    type: "Baseline Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: ClusteringModel,
    type: "Clustering Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: GaussianProcessModel,
    type: "Gaussian Process Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: GeneralRegressionModel,
    type: "General Regression Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: MiningModel,
    type: "Mining Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: NaiveBayesModel,
    type: "Naive Bayes Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: NearestNeighborModel,
    type: "Nearest Neighbor Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: NeuralNetwork,
    type: "Neural Network",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: RegressionModel,
    type: "Regression Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.VIEWER,
    factory: undefined,
}, {
    model: RuleSetModel,
    type: "RuleSet Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: SequenceModel,
    type: "Sequence Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: Scorecard,
    type: "Scorecard",
    iconUrl: "card-icon-scorecard.svg",
    capability: SupportedCapability.EDITOR,
    factory: () => {
        const model = new Scorecard({
            modelName: "Untitled model",
            MiningSchema: { MiningField: [] },
            Characteristics: { Characteristic: [] },
            Output: { OutputField: [] },
            functionName: "regression",
        });
        model._type = "Scorecard";
        return model;
    },
}, {
    model: SupportVectorMachineModel,
    type: "Support Vector Machine Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: TextModel,
    type: "Text Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: TimeSeriesModel,
    type: "Time Series Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: TreeModel,
    type: "Tree Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
});
export const isCollection = (collection) => {
    if (collection === undefined) {
        return false;
    }
    return collection.length !== 0;
};
export const getModelName = (model) => {
    var _a;
    return (_a = get(model, "modelName")) !== null && _a !== void 0 ? _a : "";
};
export const getModelType = (model) => {
    for (const _mapping of PMMLModels) {
        if (model instanceof _mapping.model) {
            return _mapping.type;
        }
    }
};
export const getModelIconUrlByType = (type) => {
    for (const _mapping of PMMLModels) {
        if (type === _mapping.type) {
            return ICON_BASE + _mapping.iconUrl;
        }
    }
    return ICON_BASE + ICON_DEFAULT;
};
export const isSupportedModelType = (model) => {
    for (const _mapping of PMMLModels) {
        if (model instanceof _mapping.model) {
            return _mapping.capability === SupportedCapability.VIEWER || _mapping.capability === SupportedCapability.EDITOR;
        }
    }
    return false;
};
export const findIncrementalName = (name, existingNames, startsFrom) => {
    let newName = "";
    let counter = startsFrom;
    do {
        const potentialName = `${name}${counter !== 1 ? ` ${counter}` : ""}`;
        const found = existingNames.filter((existingName) => existingName === potentialName);
        if (found.length === 0) {
            newName = potentialName;
        }
        counter++;
    } while (newName.length === 0);
    return newName;
};
export const getDataDictionary = (pmml) => {
    return get(pmml, Builder().forDataDictionary().build().path);
};
export const getMiningSchema = (pmml, modelIndex) => {
    return get(pmml, Builder().forModel(modelIndex).forMiningSchema().build().path);
};
export const getMiningField = (pmml, modelIndex, miningFieldIndex) => {
    return get(pmml, Builder().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).build().path);
};
export const getOutputs = (pmml, modelIndex) => {
    return get(pmml, Builder().forModel(modelIndex).forOutput().build().path);
};
export const getCharacteristics = (pmml, modelIndex) => {
    return get(pmml, Builder().forModel(modelIndex).forCharacteristics().build().path);
};
export const getBaselineScore = (pmml, modelIndex) => {
    return get(pmml, Builder().forModel(modelIndex).forBaselineScore().build().path);
};
export const getUseReasonCodes = (pmml, modelIndex) => {
    return get(pmml, Builder().forModel(modelIndex).forUseReasonCodes().build().path);
};
//# sourceMappingURL=PMMLModelHelper.js.map