import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useRef, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import "./ConstraintsRangeEdit.scss";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
const ConstraintsRangeEdit = (props) => {
    const { dataFieldIndex, ranges, onAdd, onChange, onDelete, countLimit } = props;
    const [addedRange, setAddedRange] = useState();
    const updateRange = (index, range) => {
        const newRanges = [...ranges];
        newRanges[index] = range;
        onChange(newRanges);
    };
    const addRange = () => {
        onAdd();
        setAddedRange(ranges.length);
    };
    const updateAddedRange = (position) => {
        setAddedRange(position);
    };
    return (_jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(TextContent, { children: _jsx(Text, { component: TextVariants.small, children: "At least the Start Value or End Value is required for each interval" }) }) }), _jsx(StackItem, { children: ranges.map((range, index) => (_jsx(RangeEdit, { dataFieldIndex: dataFieldIndex, range: range, rangesCount: ranges.length, index: index, onSave: updateRange, onDelete: onDelete, addedRange: addedRange, updateAddedRange: updateAddedRange }, index))) }), _jsx(StackItem, { children: _jsx(Button, { variant: "secondary", onClick: addRange, isDisabled: countLimit !== undefined && ranges.length >= countLimit, isSmall: true, ouiaId: "add-another-interval", children: "Add another interval" }) })] }));
};
export default ConstraintsRangeEdit;
const RangeEdit = (props) => {
    const { dataFieldIndex, range, rangesCount, index, onSave, onDelete, addedRange, updateAddedRange } = props;
    const [rangeValues, setRangeValues] = useState(range);
    const [submitChanges, setSubmitChanges] = useState(false);
    const handleRangeChange = (value, event) => {
        switch (event.target.name) {
            case "start-value":
                setRangeValues({ ...rangeValues, start: { ...rangeValues.start, value: value } });
                break;
            case "start-included":
                setRangeValues({ ...rangeValues, start: { ...rangeValues.start, included: value } });
                break;
            case "end-value":
                setRangeValues({ ...rangeValues, end: { ...rangeValues.end, value: value } });
                break;
            case "end-included":
                setRangeValues({ ...rangeValues, end: { ...rangeValues.end, included: value } });
                break;
            default:
                break;
        }
    };
    const handleDelete = () => {
        onDelete(index);
    };
    const saveChange = () => {
        setSubmitChanges(true);
    };
    const rangeRef = useRef(null);
    useEffect(() => {
        if (submitChanges) {
            onSave(index, rangeValues);
            setSubmitChanges(false);
        }
    }, [submitChanges, rangeValues]);
    useEffect(() => {
        setRangeValues(range);
    }, [range]);
    useEffect(() => {
        if (rangeRef.current && addedRange === index) {
            const container = document.querySelector(".data-dictionary__properties-edit__form .constraints__form");
            container === null || container === void 0 ? void 0 : container.scroll({ top: container === null || container === void 0 ? void 0 : container.scrollHeight, behavior: "smooth" });
            updateAddedRange(undefined);
        }
    }, [addedRange, index, rangeRef.current]);
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forDataDictionary().forDataField(dataFieldIndex).forInterval(index).build()), [range]);
    return (_jsx("section", { ref: rangeRef, "data-ouia-component-id": `interval-${index}`, "data-ouia-component-type": "interval-item", children: _jsxs(Split, { hasGutter: true, className: "constraints__range-item", children: [_jsxs(SplitItem, { isFilled: true, children: [_jsx(FormGroup, { label: "Start Value", fieldId: `start-value-${index}`, helperText: validations[0] ? "Please enter start and/or end value" : "", children: _jsx(TextInput, { type: "number", id: `start-value-${index}`, name: "start-value", value: rangeValues.start.value, validated: validations.length === 0 ? "default" : "warning", onChange: handleRangeChange, onBlur: saveChange, tabIndex: (index + 1) * 10 + 1, autoComplete: "off", ouiaId: "start-value" }) }), _jsx(FormGroup, { fieldId: `start-included-${index}`, className: "constraints__include-range", children: _jsx(Checkbox, { label: "Include Start Value", "aria-label": "Include Start Value", id: `start-included-${index}`, name: "start-included", isChecked: rangeValues.start.included, onChange: handleRangeChange, onClick: saveChange, tabIndex: (index + 1) * 10 + 3, ouiaId: "is-start-included" }) })] }), _jsxs(SplitItem, { isFilled: true, children: [_jsx(FormGroup, { label: "End Value", fieldId: `end-value-${index}`, helperText: validations[0] ? "Please enter start and/or end value" : "", children: _jsx(TextInput, { type: "number", id: `end-value-${index}`, name: "end-value", value: rangeValues.end.value, validated: validations.length === 0 ? "default" : "warning", onChange: handleRangeChange, onBlur: saveChange, tabIndex: (index + 1) * 10 + 2, autoComplete: "off", ouiaId: "end-value" }) }), _jsx(FormGroup, { fieldId: `end-included-${index}`, className: "constraints__include-range", children: _jsx(Checkbox, { label: "Include End Value", "aria-label": "Include End Value", id: `end-included-${index}`, name: "end-included", isChecked: rangeValues.end.included, onChange: handleRangeChange, onClick: saveChange, tabIndex: (index + 1) * 10 + 4, ouiaId: "is-end-included" }) })] }), _jsx(SplitItem, { children: _jsx(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" }, children: _jsx(FlexItem, { children: _jsx(Button, { variant: "plain", "aria-label": "Delete Range", onClick: handleDelete, isDisabled: rangesCount === 1, tabIndex: (index + 1) * 10 + 5, ouiaId: "delete-item", children: _jsx(TrashIcon, {}) }) }) }) })] }) }));
};
//# sourceMappingURL=ConstraintsRangeEdit.js.map