import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useState } from "react";
import { useSelector } from "react-redux";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { CloseIcon } from "@patternfly/react-icons/dist/js/icons/close-icon";
import { WarningTriangleIcon } from "@patternfly/react-icons/dist/js/icons/warning-triangle-icon";
import { Actions } from "../../../reducers";
import DataDictionaryContainer from "../DataDictionaryContainer/DataDictionaryContainer";
import { convertPMML2DD, convertToDataField } from "../dataDictionaryUtils";
import { Operation, useOperation } from "../../EditorScorecard";
import { useBatchDispatch, useHistoryService } from "../../../history";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicatorTooltip } from "../../EditorCore/atoms";
const DataDictionaryHandler = () => {
    const [isDataDictionaryOpen, setIsDataDictionaryOpen] = useState(false);
    const pmmlDataDictionary = useSelector((state) => state.DataDictionary);
    const dictionary = useMemo(() => convertPMML2DD(pmmlDataDictionary), [pmmlDataDictionary]);
    const { setActiveOperation } = useOperation();
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const handleDataDictionaryToggle = () => {
        setActiveOperation(Operation.NONE);
        setIsDataDictionaryOpen(!isDataDictionaryOpen);
    };
    const addField = (name, type, optype) => {
        dispatch({
            type: Actions.AddDataDictionaryField,
            payload: {
                name: name,
                type: type,
                optype: optype,
            },
        });
    };
    const addBatchFields = (fields) => {
        dispatch({
            type: Actions.AddBatchDataDictionaryFields,
            payload: {
                dataDictionaryFields: fields,
            },
        });
    };
    const deleteField = (index) => {
        dispatch({
            type: Actions.DeleteDataDictionaryField,
            payload: {
                index,
            },
        });
    };
    const reorderFields = (oldIndex, newIndex) => {
        dispatch({
            type: Actions.ReorderDataDictionaryFields,
            payload: {
                oldIndex,
                newIndex,
            },
        });
    };
    const updateField = (index, originalName, field) => {
        dispatch({
            type: Actions.UpdateDataDictionaryField,
            payload: {
                dataDictionaryIndex: index,
                dataField: convertToDataField(field),
                originalName: originalName,
            },
        });
    };
    const handleEditingPhase = (status) => {
        setActiveOperation(status ? Operation.UPDATE_DATA_DICTIONARY : Operation.NONE);
    };
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forDataDictionary().build()), [dictionary]);
    const header = (_jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { isFilled: true, children: _jsx(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: "Data Dictionary" }) }), _jsx(SplitItem, { children: _jsx(Button, { type: "button", variant: ButtonVariant.plain, onClick: handleDataDictionaryToggle, "data-title": "DataDictionaryModalClose", children: _jsx(CloseIcon, {}) }) })] }));
    return (_jsxs(_Fragment, { children: [validations.length === 0 && (_jsx(Button, { variant: "secondary", onClick: handleDataDictionaryToggle, "data-title": "DataDictionary", children: "Set Data Dictionary" })), validations.length > 0 && (_jsx(ValidationIndicatorTooltip, { validations: validations, children: _jsx(Button, { variant: "secondary", icon: _jsx(WarningTriangleIcon, { size: "sm", color: "orange" }), onClick: handleDataDictionaryToggle, "data-title": "DataDictionary", children: "Set Data Dictionary" }) })), _jsx(Modal, { "aria-label": "data-dictionary", title: "Data Dictionary", header: header, isOpen: isDataDictionaryOpen, showClose: false, variant: ModalVariant.large, onEscapePress: () => false, "data-title": "DataDictionaryModal", children: _jsx(DataDictionaryContainer, { dataDictionary: dictionary, onAdd: addField, onEdit: updateField, onDelete: deleteField, onReorder: reorderFields, onBatchAdd: addBatchFields, onEditingPhaseChange: handleEditingPhase }) })] }));
};
export default DataDictionaryHandler;
//# sourceMappingURL=DataDictionaryHandler.js.map