import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { ActionGroup, Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import "./MultipleDataTypesAdd.scss";
const MultipleDataTypeAdd = ({ onAdd, onCancel }) => {
    const [input, setInput] = useState("");
    const [inputValidation, setInputValidation] = useState("default");
    useEffect(() => {
        var _a;
        (_a = document.querySelector(`#data-types`)) === null || _a === void 0 ? void 0 : _a.focus();
    }, []);
    const handleInputChange = (value) => {
        setInput(value);
    };
    const validateInput = () => {
        const validation = input.trim().length > 0 ? "success" : "error";
        setInputValidation(validation);
        return validation;
    };
    const handleSubmit = (event) => {
        if (validateInput() === "success") {
            onAdd(input);
        }
        event.preventDefault();
    };
    return (_jsx("section", { children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(TextContent, { children: [_jsx(Text, { component: TextVariants.h3, children: "Add Multiple Data Types" }), _jsxs(Text, { component: TextVariants.p, children: ["You can add multiple data types by entering their names below. Add them one per line.", _jsx("br", {}), "They will be created with the default type of ", _jsx("em", { children: "String" }), ". You will be able to edit them later."] })] }) }), _jsx(StackItem, { children: _jsxs(Form, { onSubmit: handleSubmit, style: { gridGap: 0 }, children: [_jsx(FormGroup, { label: "Data Types", fieldId: "data-types", isRequired: true, validated: inputValidation, helperTextInvalid: "Please enter at least one Data Type Name", children: _jsx(TextArea, { className: "data-dictionary__multiple-data-types", "data-ouia-component-id": "multiple-data-types", value: input, onChange: handleInputChange, name: "data-types", isRequired: true, id: "data-types", placeholder: "First Data Type\nSecond Data Type\n..." }) }), _jsxs(ActionGroup, { children: [_jsx(Button, { variant: "primary", type: "submit", ouiaId: "add-them", children: "Add Them" }), _jsx(Button, { variant: "link", ouiaId: "cancel", onClick: () => onCancel(), children: "Never mind" })] })] }) })] }) }));
};
export default MultipleDataTypeAdd;
//# sourceMappingURL=MultipleDataTypeAdd.js.map