import { jsxs as _jsxs, jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { Tooltip, TooltipPosition } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import "./CharacteristicLabel.scss";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
import { toText } from "../organisms";
export const CharacteristicLabel = (props) => {
    const { name, value } = props;
    return (_jsxs(Label, { color: "cyan", className: "characteristic-list__item__label", children: [_jsxs("strong", { children: [name, ":"] }), "\u00A0", _jsx("span", { children: value })] }));
};
export const CharacteristicPredicateLabel = (predicate, dataFields, validations) => {
    const value = toText(predicate, dataFields);
    const truncatedText = value.length > 32 ? value.slice(0, 29) + "..." : value;
    return (_jsxs(_Fragment, { children: [value.length > truncatedText.length && (_jsx(Tooltip, { position: TooltipPosition.top, isContentLeftAligned: true, maxWidth: "100em", content: _jsx("pre", { children: value }), children: _jsxs(_Fragment, { children: [validations.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: validations, cssClass: "characteristic-list__item__label", children: _jsx("pre", { children: truncatedText }) })), validations.length === 0 && (_jsx(Label, { tabIndex: 0, color: "blue", className: "characteristic-list__item__label", children: _jsx("pre", { children: truncatedText }) }))] }) })), value.length === truncatedText.length && (_jsxs(_Fragment, { children: [validations.length > 0 && (_jsx("span", { className: "characteristic-list__item__label", children: _jsx(ValidationIndicatorLabel, { validations: validations, children: _jsxs(_Fragment, { children: [predicate && _jsx("pre", { children: value }), !predicate && (_jsxs(_Fragment, { children: [_jsx("strong", { children: "Predicate:" }), "\u00A0", _jsx("em", { children: "Missing" })] }))] }) }) })), validations.length === 0 && (_jsx(Label, { tabIndex: 0, color: "blue", className: "characteristic-list__item__label", children: _jsx("pre", { children: value }) }))] }))] }));
};
//# sourceMappingURL=CharacteristicLabel.js.map