import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState } from "react";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { Toolbar, ToolbarContent, ToolbarItem } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { SearchIcon } from "@patternfly/react-icons/dist/js/icons/search-icon";
export const LandingPageToolbar = (props) => {
    const [filter, setFilter] = useState("");
    const { onFilter, hasUnsupportedModels, showUnsupportedModels, onShowUnsupportedModels } = props;
    return (_jsx(Toolbar, { id: "landing-page-toolbar", "data-testid": "landing-page-toolbar", children: _jsxs(ToolbarContent, { children: [_jsx(ToolbarItem, { children: _jsx(InputGroup, { children: _jsx("form", { onSubmit: (e) => e.preventDefault(), children: _jsxs("span", { style: { display: "flex" }, children: [_jsx(TextInput, { id: "model-filter-input", name: "model-filter-input", "data-testid": "landing-page-toolbar__model-filter", type: "search", "aria-label": "filter models", placeholder: "Filter models by name", onChange: (e) => setFilter(e) }), _jsx(Button, { id: "models-filter", type: "submit", "data-testid": "landing-page-toolbar__submit", variant: ButtonVariant.control, "aria-label": "filter button for filter input", onClick: (e) => onFilter(filter), children: _jsx(SearchIcon, {}) })] }) }) }) }), hasUnsupportedModels && (_jsx(ToolbarItem, { children: _jsx(Switch, { id: "only-supported-models-switch", "data-testid": "landing-page-toolbar__supported-models", label: "Show unsupported models", isChecked: showUnsupportedModels, onChange: onShowUnsupportedModels }) }))] }) }));
};
//# sourceMappingURL=LandingPageToolbar.js.map