import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEffect, useMemo, useState } from "react";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { CSSTransition, SwitchTransition } from "react-transition-group";
import { isEqual, pickBy } from "lodash";
import EmptyMiningSchema from "../EmptyMiningSchema/EmptyMiningSchema";
import MiningSchemaFields from "../MiningSchemaFields/MiningSchemaFields";
import MiningSchemaAddFields from "../MiningSchemaAddFields/MiningSchemaAddFields";
import MiningSchemaPropertiesEdit from "../MiningSchemaPropertiesEdit/MiningSchemaPropertiesEdit";
import "./MiningSchemaContainer.scss";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import NoMiningSchemaFieldsOptions from "../NoMiningSchemaFieldsOptions/NoMiningSchemaFieldsOptions";
const MiningSchemaContainer = (props) => {
    const { modelIndex, dataDictionary, miningSchema, onAddField, onDeleteField, onUpdateField } = props;
    const [fields, setFields] = useState(prepareFieldOptions(dataDictionary, miningSchema));
    const [viewSection, setViewSection] = useState("overview");
    const [editingField, setEditingField] = useState(-1);
    const [miningFieldFocusIndex, setMiningFieldFocusIndex] = useState(undefined);
    const handleAddFields = (fieldsToAdd) => {
        if (fieldsToAdd.length) {
            onAddField(fieldsToAdd);
        }
    };
    const handleDeleteField = (index, interaction) => {
        var _a;
        onDeleteField(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setMiningFieldFocusIndex(index);
        }
        setEditingField(-1);
    };
    const handleEditField = (index) => {
        setEditingField(index);
    };
    const handleCancelEditing = () => {
        setEditingField(-1);
    };
    const goToProperties = () => {
        setViewSection("properties");
    };
    const handlePropertiesSave = (field) => {
        if (!isEqual(field, pickBy(miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[editingField], (value) => value !== undefined))) {
            onUpdateField(editingField, miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[editingField].name, field);
        }
    };
    const handlePropertiesClose = () => {
        setViewSection("overview");
    };
    const handlePropertyDelete = (index, updatedField) => {
        onUpdateField(index, miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[editingField].name, updatedField);
    };
    const getTransition = (currentState) => {
        if (currentState === "overview") {
            return "mining-schema__overview";
        }
        else if (currentState === "properties") {
            return "mining-schema__properties";
        }
    };
    useEffect(() => {
        setFields(prepareFieldOptions(dataDictionary, miningSchema));
    }, [dataDictionary, miningSchema]);
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().build()), [dataDictionary, miningSchema]);
    useEffect(() => {
        var _a;
        if (miningFieldFocusIndex !== undefined) {
            (_a = document.querySelector(`#mining-schema-field-n${miningFieldFocusIndex}`)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [miningSchema, miningFieldFocusIndex]);
    const isDisabled = useMemo(() => {
        return fields.length === 0 || editingField !== -1;
    }, [fields, editingField]);
    return (_jsx("section", { className: "mining-schema", "data-testid": "mining-schema-container", "data-ouia-component-id": "mining-container", "data-ouia-component-type": "editor-container", children: _jsx(MiningSchemaContext.Provider, { value: editingField, children: _jsx(SwitchTransition, { mode: "out-in", children: _jsx(CSSTransition, { timeout: {
                        enter: 230,
                        exit: 100,
                    }, classNames: getTransition(viewSection), children: _jsxs(_Fragment, { children: [viewSection === "overview" && (_jsxs(Stack, { hasGutter: true, className: "mining-schema__overview", children: [_jsx(StackItem, { children: _jsx(Title, { headingLevel: "h4", size: TitleSizes.xl, children: "Add Fields" }) }), _jsx(StackItem, { children: _jsx(MiningSchemaAddFields, { options: fields, onAdd: handleAddFields, isDisabled: isDisabled }) }), validations.length > 0 && (_jsx("section", { className: "mining-schema__validation-alert", "data-ouia-component-id": "validation-container", "data-ouia-component-type": "validation-alerts", children: _jsx(Alert, { variant: "warning", isInline: true, title: "Some items are invalid and need attention." }) })), _jsx(StackItem, { className: "mining-schema__fields", children: _jsxs("section", { children: [(miningSchema === undefined || (miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField.length) === 0) && (_jsxs(_Fragment, { children: [fields.length === 0 && (_jsx(Bullseye, { style: { height: "40vh" }, children: _jsx(NoMiningSchemaFieldsOptions, {}) })), " ", fields.length > 0 && (_jsx(Bullseye, { style: { height: "40vh" }, children: _jsx(EmptyMiningSchema, {}) }))] })), miningSchema && miningSchema.MiningField.length > 0 && (_jsx(_Fragment, { children: _jsx(MiningSchemaFields, { modelIndex: modelIndex, dataDictionary: dataDictionary, fields: miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField, onAddProperties: goToProperties, onDelete: handleDeleteField, onPropertyDelete: handlePropertyDelete, onEdit: handleEditField, onCancel: handleCancelEditing }) }))] }) })] })), viewSection === "properties" && (_jsx(MiningSchemaPropertiesEdit, { modelIndex: modelIndex, miningFieldIndex: editingField, field: miningSchema.MiningField[editingField], onSave: handlePropertiesSave, onClose: handlePropertiesClose }))] }) }, viewSection) }) }) }));
};
export default MiningSchemaContainer;
export const MiningSchemaContext = React.createContext(-1);
const prepareFieldOptions = (dictionary, miningSchema) => {
    if (dictionary) {
        return dictionary.DataField.filter((field) => field.name !== undefined).map((field) => ({
            name: field.name,
            isSelected: miningSchema
                ? (miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField.findIndex((miningField) => miningField.name === field.name)) > -1
                : false,
        }));
    }
    else {
        return [];
    }
};
//# sourceMappingURL=MiningSchemaContainer.js.map