import { Actions } from "./Actions";
import { Characteristics } from "@kie-tools/pmml-editor-marshaller";
import { immerable } from "immer";
import { Builder } from "../paths";
Characteristics[immerable] = true;
export const CharacteristicsReducer = (historyService) => {
    return (state, action) => {
        switch (action.type) {
            case Actions.Scorecard_AddCharacteristic:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).forCharacteristics().build(), (draft) => {
                    draft.Characteristic.push({
                        name: action.payload.name,
                        reasonCode: action.payload.reasonCode,
                        baselineScore: action.payload.baselineScore,
                        Attribute: [],
                    });
                });
                break;
            case Actions.Scorecard_DeleteCharacteristic:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).forCharacteristics().build(), (draft) => {
                    const characteristicIndex = action.payload.characteristicIndex;
                    if (characteristicIndex >= 0 && characteristicIndex < draft.Characteristic.length) {
                        draft.Characteristic.splice(characteristicIndex, 1);
                    }
                });
        }
        return state;
    };
};
//# sourceMappingURL=CharacteristicsReducer.js.map