import { Actions } from "./Actions";
import { Builder } from "../paths";
import { validateMiningFields } from "../validation/MiningSchema";
import { getMiningSchema } from "../PMMLModelHelper";
export const MiningSchemaReducer = (historyService, validationRegistry) => {
    return (state, action) => {
        switch (action.type) {
            case Actions.AddMiningSchemaFields:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).forMiningSchema().build(), (draft) => {
                    action.payload.names.forEach((name) => {
                        draft.MiningField.push({
                            name: name,
                        });
                    });
                });
                break;
            case Actions.DeleteMiningSchemaField:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).forMiningSchema().build(), (draft) => {
                    const miningSchemaIndex = action.payload.miningSchemaIndex;
                    if (miningSchemaIndex >= 0 && miningSchemaIndex < draft.MiningField.length) {
                        draft.MiningField.splice(miningSchemaIndex, 1);
                    }
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    if (miningSchema !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forMiningSchema().build());
                        validateMiningFields(modelIndex, miningSchema.MiningField, validationRegistry);
                    }
                });
        }
        return state;
    };
};
//# sourceMappingURL=MiningSchemaReducer.js.map