import { ValidationEntry } from "./ValidationRegistry";
import { ValidationLevel } from "./ValidationLevel";
import { Builder } from "../paths";
export const validateBaselineScore = (modelIndex, useReasonCodes, baselineScore, characteristics, validationRegistry) => {
    if ((useReasonCodes === undefined || useReasonCodes) &&
        baselineScore === undefined &&
        (characteristics.length === 0 ||
            characteristics.filter((characteristic) => characteristic.baselineScore === undefined).length > 0)) {
        validationRegistry.set(Builder().forModel(modelIndex).forBaselineScore().build(), new ValidationEntry(ValidationLevel.WARNING, `Baseline score is required`));
    }
};
//# sourceMappingURL=ModelCoreProperties.js.map