import { jsx as _jsx } from "react/jsx-runtime";
import { EnvelopeServer, EnvelopeServerType } from "@kie-tools-core/envelope-bus/dist/channel";
import * as React from "react";
import { useImperativeHandle, useMemo, useRef } from "react";
import { useConnectedEnvelopeServer } from "@kie-tools-core/envelope-bus/dist/hooks";
import { ContainerType } from "../api";
const containerStyles = {
    display: "flex",
    flex: 1,
    flexDirection: "column",
    width: "100%",
    height: "100%",
    border: "none",
    margin: 0,
    padding: 0,
    overflow: "hidden",
};
export function RefForwardingEmbeddedEnvelope(props, forwardRef) {
    const iframeRef = useRef(null);
    const divRef = useRef(null);
    const bus = useMemo(() => ({
        postMessage(message) {
            var _a, _b;
            if (props.config.containerType === ContainerType.DIV) {
                window.postMessage(message, "*");
            }
            else {
                (_b = (_a = iframeRef.current) === null || _a === void 0 ? void 0 : _a.contentWindow) === null || _b === void 0 ? void 0 : _b.postMessage(message, "*");
            }
        },
    }), [props.config.containerType]);
    const envelopeServer = useMemo(() => new EnvelopeServer(bus, props.origin, (self) => props.pollInit(self, () => props.config.containerType === ContainerType.DIV ? divRef.current : iframeRef.current), props.config.containerType === ContainerType.DIV ? EnvelopeServerType.LOCAL : EnvelopeServerType.REMOTE), [bus, props.origin, props.pollInit, props.config.containerType]);
    useImperativeHandle(forwardRef, () => {
        return props.refDelegate(envelopeServer);
    }, [envelopeServer, props.refDelegate]);
    useConnectedEnvelopeServer(envelopeServer, props.apiImpl);
    if (props.config.containerType === ContainerType.DIV) {
        return _jsx("div", { ref: divRef });
    }
    return _jsx("iframe", { ref: iframeRef, src: props.config.envelopePath, style: containerStyles, title: "X" });
}
export const EmbeddedEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedEnvelopeFactory.js.map