import { MiningSchema, NearestNeighborModel } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
export const NEAREST_NEIGHBOR_MODEL = `
elements.elements[(name = "NearestNeighborModel")] ~> $map(function($v, $i) {
  $merge([
    $nearestNeighborModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function nearestNeighborModelFactory() {
    return new NearestNeighborModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        ComparisonMeasure: { kind: "distance" },
        KNNInputs: { KNNInput: [] },
        TrainingInstances: { InstanceFields: { InstanceField: [] } },
        functionName: "regression",
        numberOfNeighbors: 0,
    });
}
//# sourceMappingURL=NearestNeighborModel.js.map