import { MiningSchema, RegressionModel, RegressionTable } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
const NUMERIC_PREDICTOR = `
"NumericPredictor": $singletonArray(
  $v.elements[(name = "NumericPredictor")] ~> $map(function($v, $i) {
    $merge([
      $v.attributes,
      {
        "exponent": $number($v.attributes.exponent),
        "coefficient": $number($v.attributes.coefficient)
      }
    ])
  })
)`;
const CATEGORICAL_PREDICTOR = `
"CategoricalPredictor": $singletonArray(
  $v.elements[(name = "CategoricalPredictor")] ~> $map(function($v, $i) {
    $merge([
      $v.attributes,
      {
        "coefficient": $number($v.attributes.coefficient)
      }
    ])
  })
)`;
const PREDICTOR_TERM = `
  "PredictorTerm": $v.elements[(name = "PredictorTerm")] ~> $map(function($v, $i) {
    $v
})`;
const REGRESSION_TABLE = `
"RegressionTable": $singletonArray(
  $v.elements[(name = "RegressionTable")] ~> $map(function($v, $i) {
    $merge([
      $v.attributes,
      {
        "intercept": $number($v.attributes.intercept)
      },
      {
        ${NUMERIC_PREDICTOR},
        ${CATEGORICAL_PREDICTOR},
        ${PREDICTOR_TERM}
      }
    ])
  })
)`;
export const REGRESSION_MODEL = `
elements.elements[(name = "RegressionModel")] ~> $map(function($v, $i) {
  $merge([
    $regressionModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS},
      ${REGRESSION_TABLE}
    }
  ])
})`;
export function regressionModelFactory() {
    return new RegressionModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        RegressionTable: [new RegressionTable({ intercept: 0.0 })],
        functionName: "regression",
    });
}
//# sourceMappingURL=RegressionModel.js.map