import { MiningSchema, TextModel } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
export const TEXT_MODEL = `
elements.elements[(name = "TextModel")] ~> $map(function($v, $i) {
  $merge([
    $textModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function textModelFactory() {
    return new TextModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        DocumentTermMatrix: { Matrix: {} },
        TextCorpus: {},
        TextDictionary: {},
        functionName: "regression",
        numberOfDocuments: 0,
        numberOfTerms: 0,
    });
}
//# sourceMappingURL=TextModel.js.map