import { MiningSchema, TimeSeriesModel } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
export const TIME_SERIES_MODEL = `
elements.elements[(name = "TimeSeriesModel")] ~> $map(function($v, $i) {
  $merge([
    $timeSeriesModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function timeSeriesModelFactory() {
    return new TimeSeriesModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        functionName: "regression",
        bestFit: "ARIMA",
    });
}
//# sourceMappingURL=TimeSeriesModel.js.map