import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
const NUMERIC_PREDICTOR = `[
  $v.NumericPredictor ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "NumericPredictor", 
      "attributes": {
        "name": $v.name,
        "exponent": $v.exponent,
        "coefficient": $v.coefficient
      }
    }
  })
]`;
const CATEGORICAL_PREDICTOR = `[
  $v.CategoricalPredictor ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "CategoricalPredictor", 
      "attributes": {
        "name": $v.name,
        "value": $v.value,
        "coefficient": $v.coefficient
      }
    }
  })
]`;
const PREDICTOR_TERM = `[
  $v.PredictorTerm ~> $map(function($v, $i) {
    $v
  })
]`;
const REGRESSION_TABLE = `[
  $v.RegressionTable ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "RegressionTable", 
      "attributes": {
        "intercept": $v.intercept,
        "targetCategory": $v.targetCategory 
      },
      "elements": $append(${NUMERIC_PREDICTOR},
                    $append(${CATEGORICAL_PREDICTOR},
                      $append([], ${PREDICTOR_TERM})
                    )
                  )
    }
  })
]`;
export const REGRESSION_MODEL = `[
  models[(_type = "RegressionModel")] ~> $map(function($v, $i) {
    {
      "type": "element",
      "name": "RegressionModel",
      "attributes": {
        "modelName": $v.modelName,
        "functionName": $v.functionName,
        "algorithmName": $v.algorithmName,
        "modelType": $v.modelType,
        "targetFieldName": $v.targetFieldName,
        "normalizationMethod": $v.normalizationMethod,
        "isScorable": $v.isScorable
      },
      "elements": $append(${MINING_SCHEMA},
                    $append(${OUTPUT}, 
                      $append(${REGRESSION_TABLE}, 
                        $append(${MODEL_STATS},
                          $append(${MODEL_EXPLANATION},
                            $append(${MODEL_VERIFICATION},
                              $append(${TARGETS},
                                $append([], ${LOCAL_TRANSFORMATIONS})
                              )
                            )
                          )
                        )
                      )
                    )
                  )
    }
  })
]`;
//# sourceMappingURL=RegressionModel.js.map