export function buildXmlHref({ namespace, id }) {
    return `${namespace !== null && namespace !== void 0 ? namespace : ""}#${id}`;
}
export function parseXmlHref(href) {
    const split = href.split("#");
    if (split.length <= 1) {
        return { namespace: undefined, id: split[0] };
    }
    if (split.length > 2) {
        throw new Error(`XML URI can't have hashes (#) on neither the namespace or the id. Alledged URI: '${href}'`);
    }
    return { namespace: split[0] ? split[0] : undefined, id: split[1] };
}
export function addNamespaceToHref({ href, namespace }) {
    if (namespace === undefined) {
        return href;
    }
    const { namespace: hrefNamespace, id } = parseXmlHref(href);
    if (hrefNamespace !== undefined) {
        return href;
    }
    return buildXmlHref({ namespace, id });
}
//# sourceMappingURL=xmlHrefs.js.map