import { parseXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
export function getXmlNamespaceDeclarationName({ rootElement, namespace, }) {
    const xmlnsEntry = Object.entries(rootElement !== null && rootElement !== void 0 ? rootElement : {}).find(([k, v]) => v === namespace && (k === "@_xmlns" || k.startsWith("@_xmlns:")));
    if (!xmlnsEntry) {
        return undefined;
    }
    if (xmlnsEntry[0] === "@_xmlns") {
        return undefined;
    }
    return parseXmlQName(xmlnsEntry[0]).localPart;
}
//# sourceMappingURL=xmlNamespaceDeclarations.js.map