"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.encodeJsonPatchSubpath = encodeJsonPatchSubpath;
exports.patchK8sResourceYaml = patchK8sResourceYaml;
var fast_json_patch_1 = require("fast-json-patch");
var parseK8sResourceYamls_1 = require("./parseK8sResourceYamls");
var jsYaml = require("js-yaml");
var interpolateK8sResourceYaml_1 = require("./interpolateK8sResourceYaml");
var common_1 = require("./common");
function encodeJsonPatchSubpath(path) {
    return path.replaceAll("~", "~0").replaceAll("/", "~1");
}
function isValueOfType(type, value) {
    switch (type) {
        case "null":
        case "undefined":
            if (!value) {
                return true;
            }
            return false;
        case "array":
            if (Array.isArray(value)) {
                return true;
            }
            return false;
        case "object":
            if (typeof value === "object" && !Array.isArray(value)) {
                return true;
            }
            return false;
        case "basic":
            if (typeof value === "boolean" || typeof value === "string" || typeof value === "number") {
                return true;
            }
            return false;
    }
}
function patchK8sResourceYaml(k8sResourceYaml, patches, parametersTokens) {
    var parsedAndPatchedYamls = (0, parseK8sResourceYamls_1.parseK8sResourceYamls)(k8sResourceYaml.split("\n---\n")).map(function (resource) {
        var e_1, _a, e_2, _b;
        var updatedResource = resource;
        try {
            for (var patches_1 = __values(patches), patches_1_1 = patches_1.next(); !patches_1_1.done; patches_1_1 = patches_1.next()) {
                var patch = patches_1_1.value;
                try {
                    var testFiltersResults = !patch.testFilters
                        ? true
                        : (0, fast_json_patch_1.applyPatch)(updatedResource, patch.testFilters, false, false).every(function (_a) {
                            var test = _a.test;
                            return Boolean(test);
                        });
                    if (testFiltersResults) {
                        try {
                            for (var _c = (e_2 = void 0, __values(patch.jsonPatches)), _d = _c.next(); !_d.done; _d = _c.next()) {
                                var jsonPatch = _d.value;
                                if (jsonPatch.op === "checkType") {
                                    var value = (0, fast_json_patch_1.getValueByPointer)(updatedResource, jsonPatch.path);
                                    if (isValueOfType(jsonPatch.type, value)) {
                                        continue;
                                    }
                                    else {
                                        break;
                                    }
                                }
                                try {
                                    var newDocument = (0, fast_json_patch_1.applyPatch)(updatedResource, [jsonPatch], false, false).newDocument;
                                    updatedResource = newDocument;
                                }
                                catch (e) {
                                    (0, common_1.consoleDebugMessage)("Failed to apply patch -> \n".concat(JSON.stringify(jsonPatch)));
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                }
                catch (e) {
                    (0, common_1.consoleDebugMessage)("Failed to test filters -> \n".concat(JSON.stringify(patch.testFilters)));
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (patches_1_1 && !patches_1_1.done && (_a = patches_1.return)) _a.call(patches_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return updatedResource;
    });
    var finalYaml = parsedAndPatchedYamls.map(function (resource) { return jsYaml.dump(resource); }).join("\n---\n");
    return (0, interpolateK8sResourceYaml_1.interpolateK8sResourceYaml)(finalYaml, parametersTokens);
}
//# sourceMappingURL=patchK8sResourceYaml.js.map