import { Specification } from "@severlessworkflow/sdk-typescript";
import * as jsonc from "jsonc-parser";
export declare function getFunctions(rootNode: jsonc.Node): {
    sourceModel?: any | undefined;
    name: string;
    type?: "rest" | "asyncapi" | "rpc" | "graphql" | "odata" | "expression" | "custom";
    metadata?: {
        [x: string]: string;
        [x: number]: string;
    } | undefined;
    operation: string;
    authRef?: string;
}[];
export declare function getEvents(rootNode: jsonc.Node): {
    sourceModel?: any | undefined;
    name?: string;
    source?: string;
    type?: string;
    kind?: "consumed" | "produced";
    correlation?: {
        [x: number]: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        };
        [Symbol.iterator]: () => IterableIterator<{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }>;
        readonly [Symbol.unscopables]: {
            [x: number]: boolean | undefined;
            length?: boolean | undefined;
            toString?: boolean | undefined;
            toLocaleString?: boolean | undefined;
            pop?: boolean | undefined;
            push?: boolean | undefined;
            concat?: boolean | undefined;
            join?: boolean | undefined;
            reverse?: boolean | undefined;
            shift?: boolean | undefined;
            slice?: boolean | undefined;
            sort?: boolean | undefined;
            splice?: boolean | undefined;
            unshift?: boolean | undefined;
            indexOf?: boolean | undefined;
            lastIndexOf?: boolean | undefined;
            every?: boolean | undefined;
            some?: boolean | undefined;
            forEach?: boolean | undefined;
            map?: boolean | undefined;
            filter?: boolean | undefined;
            reduce?: boolean | undefined;
            reduceRight?: boolean | undefined;
            find?: boolean | undefined;
            findIndex?: boolean | undefined;
            fill?: boolean | undefined;
            copyWithin?: boolean | undefined;
            entries?: boolean | undefined;
            keys?: boolean | undefined;
            values?: boolean | undefined;
            includes?: boolean | undefined;
            flatMap?: boolean | undefined;
            flat?: boolean | undefined;
            at?: boolean | undefined;
            findLast?: boolean | undefined;
            findLastIndex?: boolean | undefined;
            toReversed?: boolean | undefined;
            toSorted?: boolean | undefined;
            toSpliced?: boolean | undefined;
            with?: boolean | undefined;
            [Symbol.iterator]?: boolean | undefined;
            readonly [Symbol.unscopables]?: boolean | undefined;
        };
        0: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        };
        length: number;
        toString: () => string;
        toLocaleString: {
            (): string;
            (locales: string | string[], options?: Intl.NumberFormatOptions & Intl.DateTimeFormatOptions): string;
        };
        pop: () => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        } | undefined;
        push: (...items: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => number;
        concat: {
            (...items: ConcatArray<{
                contextAttributeName: string;
                contextAttributeValue?: string;
            }>[]): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
            (...items: ({
                contextAttributeName: string;
                contextAttributeValue?: string;
            } | ConcatArray<{
                contextAttributeName: string;
                contextAttributeValue?: string;
            }>)[]): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
        };
        join: (separator?: string) => string;
        reverse: () => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[];
        shift: () => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        } | undefined;
        slice: (start?: number, end?: number) => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[];
        sort: (compareFn?: ((a: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, b: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }) => number) | undefined) => [{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, ...{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]];
        splice: {
            (start: number, deleteCount?: number): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
            (start: number, deleteCount: number, ...items: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
        };
        unshift: (...items: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => number;
        indexOf: (searchElement: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, fromIndex?: number) => number;
        lastIndexOf: (searchElement: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, fromIndex?: number) => number;
        every: {
            <S extends {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }>(predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => value is S, thisArg?: any): this is S[];
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => unknown, thisArg?: any): boolean;
        };
        some: (predicate: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => unknown, thisArg?: any) => boolean;
        forEach: (callbackfn: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => void, thisArg?: any) => void;
        map: <U>(callbackfn: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => U, thisArg?: any) => U[];
        filter: {
            <S extends {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }>(predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => value is S, thisArg?: any): S[];
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => unknown, thisArg?: any): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
        };
        reduce: {
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            };
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, initialValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            };
            <U>(callbackfn: (previousValue: U, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => U, initialValue: U): U;
        };
        reduceRight: {
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            };
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, initialValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            };
            <U>(callbackfn: (previousValue: U, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => U, initialValue: U): U;
        };
        find: {
            <S extends {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }>(predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, obj: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => value is S, thisArg?: any): S | undefined;
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, obj: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => unknown, thisArg?: any): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            } | undefined;
        };
        findIndex: (predicate: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, index: number, obj: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => unknown, thisArg?: any) => number;
        fill: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, start?: number, end?: number) => [{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, ...{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]];
        copyWithin: (target: number, start: number, end?: number) => [{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, ...{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]];
        entries: () => IterableIterator<[number, {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }]>;
        keys: () => IterableIterator<number>;
        values: () => IterableIterator<{
            contextAttributeName: string;
            contextAttributeValue?: string;
        }>;
        includes: (searchElement: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, fromIndex?: number) => boolean;
        flatMap: <U, This = undefined>(callback: (this: This, value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => U | ReadonlyArray<U>, thisArg?: This | undefined) => U[];
        flat: <A, D extends number = 1>(this: A, depth?: D | undefined) => FlatArray<A, D>[];
        at: (index: number) => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        } | undefined;
        findLast: {
            <S extends {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }>(predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => value is S, thisArg?: any): S | undefined;
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]) => unknown, thisArg?: any): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            } | undefined;
        };
        findLastIndex: (predicate: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[]) => unknown, thisArg?: any) => number;
        toReversed: () => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[];
        toSorted: (compareFn?: ((a: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }, b: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }) => number) | undefined) => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[];
        toSpliced: {
            (start: number, deleteCount: number, ...items: {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[]): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
            (start: number, deleteCount?: number): {
                contextAttributeName: string;
                contextAttributeValue?: string;
            }[];
        };
        with: (index: number, value: {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }) => {
            contextAttributeName: string;
            contextAttributeValue?: string;
        }[];
    } | undefined;
    dataOnly?: boolean;
    metadata?: {
        [x: string]: string;
        [x: number]: string;
    } | undefined;
}[];
export declare function getStates(rootNode: jsonc.Node): Specification.States;
//# sourceMappingURL=modelQueries.d.ts.map