import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useState } from "react";
import { importJavaClassesWizardI18nDictionaries, ImportJavaClassesWizardI18nContext, importJavaClassesWizardI18nDefaults, useImportJavaClassesWizardI18n, } from "../../i18n";
import { I18nDictionariesProvider } from "@kie-tools-core/i18n/dist/react-components";
import { ImportJavaClassesButton, ImportJavaClassesWizard, useLanguageServerAvailable, } from "./ImportJavaClassesWizard";
const ImportJavaClassesI18nDictionariesProvider = (props) => (_jsx(I18nDictionariesProvider, { defaults: importJavaClassesWizardI18nDefaults, dictionaries: importJavaClassesWizardI18nDictionaries, initialLocale: navigator.language, ctx: ImportJavaClassesWizardI18nContext, ...props }));
const ImportJavaClasses = ({ javaCodeCompletionService, gwtLayerService, loadJavaClassesInDataTypeEditor, }) => {
    const [isOpenImportJavaClassesWizard, setOpenImportJavaClassesWizard] = useState(false);
    const handleButtonClick = useCallback(() => setOpenImportJavaClassesWizard((prevState) => !prevState), []);
    const handleWizardSave = useCallback((javaClasses) => {
        var _a;
        if (gwtLayerService) {
            (_a = gwtLayerService === null || gwtLayerService === void 0 ? void 0 : gwtLayerService.importJavaClassesInDataTypeEditor) === null || _a === void 0 ? void 0 : _a.call(gwtLayerService, javaClasses);
        }
        else {
            loadJavaClassesInDataTypeEditor === null || loadJavaClassesInDataTypeEditor === void 0 ? void 0 : loadJavaClassesInDataTypeEditor(javaClasses);
        }
    }, [gwtLayerService, loadJavaClassesInDataTypeEditor]);
    return (_jsxs(ImportJavaClassesI18nDictionariesProvider, { children: [_jsx(ImportJavaClassesButton, { handleButtonClick: handleButtonClick, javaCodeCompletionService: javaCodeCompletionService }), isOpenImportJavaClassesWizard && (_jsx(ImportJavaClassesWizard, { javaCodeCompletionService: javaCodeCompletionService, isOpen: isOpenImportJavaClassesWizard, onSave: handleWizardSave, onClose: handleButtonClick }))] }));
};
export { ImportJavaClassesI18nDictionariesProvider, ImportJavaClasses, ImportJavaClassesButton, ImportJavaClassesWizard, useLanguageServerAvailable, useImportJavaClassesWizardI18n, };
//# sourceMappingURL=ImportJavaClasses.js.map