import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useState } from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { SearchIcon } from "@patternfly/react-icons/dist/js/icons/search-icon";
import { Redirect } from "react-router";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const NoData = ({ ouiaId, ouiaSafe, ...props }) => {
    let prevPath;
    if (props.location.state !== undefined) {
        prevPath = props.location.state.prev;
    }
    else {
        prevPath = props.defaultPath;
    }
    const tempPath = prevPath.split("/");
    prevPath = tempPath.filter((item) => item);
    const [isRedirect, setIsredirect] = useState(false);
    const redirectHandler = () => {
        setIsredirect(true);
    };
    return (_jsxs(_Fragment, { children: [isRedirect && _jsx(Redirect, { to: `/${prevPath[0]}` }), _jsx(PageSection, { isFilled: true, ...componentOuiaProps(ouiaId, "no-data", ouiaSafe ? ouiaSafe : !isRedirect), children: _jsx(Bullseye, { children: _jsxs(EmptyState, { variant: EmptyStateVariant.full, children: [_jsx(EmptyStateIcon, { icon: SearchIcon }), _jsx(Title, { headingLevel: "h1", size: "4xl", children: props.location.state ? props.location.state.title : "No matches" }), _jsx(EmptyStateBody, { children: props.location.state ? props.location.state.description : "No data to display" }), _jsx(Button, { variant: "primary", onClick: redirectHandler, "data-testid": "redirect-button", children: props.location.state ? props.location.state.buttonText : props.defaultButton })] }) }) })] }));
};
//# sourceMappingURL=NoData.js.map