import { ChannelType, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { SwfStunnerEditorAPI } from "@kie-tools/serverless-workflow-diagram-editor-envelope/dist/api/SwfStunnerEditorAPI";
import * as React from "react";
import { Position } from "monaco-editor";
import "./styles.scss";
interface Props {
    locale: string;
    isReadOnly: boolean;
    channelType: ChannelType;
    resourcesPathPrefix: string;
    onNewEdit: (edit: WorkspaceEdit) => void;
    onStateControlCommandUpdate: (command: StateControlCommand) => void;
}
export type ServerlessWorkflowCombinedEditorRef = {
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    colorNodes(nodeNames: string[], color: string, colorConnectedEnds: boolean): void;
    moveCursorToPosition(position: Position): void;
};
declare global {
    interface Window {
        editor: SwfStunnerEditorAPI;
    }
}
export declare const ServerlessWorkflowCombinedEditor: React.ForwardRefExoticComponent<Props & React.RefAttributes<ServerlessWorkflowCombinedEditorRef | undefined>>;
export {};
//# sourceMappingURL=ServerlessWorkflowCombinedEditor.d.ts.map