import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useState } from "react";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
import { basename } from "path";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import { EmptyState, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { FormSelect, FormSelectOption } from "@patternfly/react-core/dist/js/components/FormSelect";
import { HelpIcon } from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import AddIcon from "@patternfly/react-icons/dist/esm/icons/add-circle-o-icon";
import CubesIcon from "@patternfly/react-icons/dist/esm/icons/cubes-icon";
import { useTestScenarioEditorStoreApi } from "../store/TestScenarioStoreContext";
import { useTestScenarioEditorI18n } from "../i18n";
import { useExternalModels } from "../externalModels/TestScenarioEditorDependenciesContext";
import { createNewDmnTypeTestScenario } from "../mutations/createNewDmnTypeTestScenario";
import { createNewRuleTypeTestScenario } from "../mutations/createNewRuleTypeTestScenario";
import "./TestScenarioCreationPanel.css";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
function TestScenarioCreationPanel() {
    var _a;
    const { i18n } = useTestScenarioEditorI18n();
    const { onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath } = useExternalModels();
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const [allDmnModelNormalizedPosixRelativePaths, setAllDmnModelNormalizedPosixRelativePaths] = useState(undefined);
    const [assetType, setAssetType] = React.useState("");
    const [isAutoFillTableEnabled, setAutoFillTableEnabled] = React.useState(true);
    const [isStatelessSessionRule, setStatelessSessionRule] = React.useState(false);
    const [isTestSkipped, setTestSkipped] = React.useState(false);
    const [kieSessionRule, setKieSessionRule] = React.useState("");
    const [ruleFlowGroup, setRuleFlowGroup] = React.useState("");
    const [selectedDmnModel, setSelectedDmnModel] = useState(undefined);
    const [selectedDmnModelPathRelativeToThisScesim, setSelectedDmnModelPathRelativeToThisScesim] = useState(undefined);
    const assetsOption = [
        { value: "", label: i18n.creationPanel.assetsOption.noChoice, disabled: true },
        { value: "DMN", label: i18n.creationPanel.assetsOption.dmn, disabled: false },
        { value: "RULE", label: i18n.creationPanel.assetsOption.rule, disabled: false },
    ];
    useCancelableEffect(useCallback(({ canceled }) => {
        onRequestExternalModelsAvailableToInclude === null || onRequestExternalModelsAvailableToInclude === void 0 ? void 0 : onRequestExternalModelsAvailableToInclude().then((dmnModelNormalizedPosixPathRelativePaths) => {
            console.debug("[TestScenarioCreationPanel] The below external DMN models have been found ", dmnModelNormalizedPosixPathRelativePaths);
            if (canceled.get()) {
                setAllDmnModelNormalizedPosixRelativePaths(undefined);
                return;
            }
            setAllDmnModelNormalizedPosixRelativePaths(dmnModelNormalizedPosixPathRelativePaths.sort((modelA, modelB) => basename(modelA).localeCompare(basename(modelB))));
        }).catch((err) => {
            console.error(`[TestScenarioCreationPanel] The below error when trying to retrieve all the External DMN files from the project.`);
            console.error(err);
            throw err;
        });
    }, [onRequestExternalModelsAvailableToInclude]));
    useCancelableEffect(useCallback(({ canceled }) => {
        if (!selectedDmnModelPathRelativeToThisScesim || onRequestExternalModelByPath === undefined) {
            return;
        }
        onRequestExternalModelByPath(selectedDmnModelPathRelativeToThisScesim)
            .then((externalDMNModel) => {
            console.debug("[TestScenarioCreationPanel] The below external DMN model have been loaded ", externalDMNModel);
            if (canceled.get() || !externalDMNModel) {
                setSelectedDmnModel(undefined);
                return;
            }
            setSelectedDmnModel(externalDMNModel);
        })
            .catch((err) => {
            console.error(`[TestScenarioCreationPanel] An error occurred when parsing the selected model '${selectedDmnModelPathRelativeToThisScesim}'. Please double-check it is a non-empty valid model.`);
            console.error(err);
            throw err;
        });
    }, [onRequestExternalModelByPath, selectedDmnModelPathRelativeToThisScesim]));
    const createTestScenario = useCallback(() => testScenarioEditorStoreApi.setState((state) => {
        assetType === "DMN"
            ? createNewDmnTypeTestScenario({
                dmnModel: selectedDmnModel,
                factMappingsModel: state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping,
                factMappingValuesModel: state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario,
                isAutoFillTableEnabled,
                isTestSkipped,
                settingsModel: state.scesim.model.ScenarioSimulationModel.settings,
            })
            : createNewRuleTypeTestScenario({
                factMappingsModel: state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping,
                factMappingValuesModel: state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario,
                isStatelessSessionRule,
                isTestSkipped,
                kieSessionRule,
                ruleFlowGroup,
                settingsModel: state.scesim.model.ScenarioSimulationModel.settings,
            });
    }), [
        assetType,
        isAutoFillTableEnabled,
        isStatelessSessionRule,
        isTestSkipped,
        kieSessionRule,
        ruleFlowGroup,
        selectedDmnModel,
        testScenarioEditorStoreApi,
    ]);
    const [isModelSelectOpen, setModelSelectOpen] = useState(false);
    return (_jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { headingLevel: "h6", size: "md", children: i18n.creationPanel.title }), _jsxs(Form, { className: "kie-scesim-editor--creation-form", isHorizontal: true, children: [_jsx(FormGroup, { isRequired: true, label: i18n.creationPanel.assetsGroup, children: _jsx(FormSelect, { id: "asset-type-select", name: "asset-type-select", onChange: (value) => setAssetType(value), value: assetType, children: assetsOption.map((option, index) => (_jsx(FormSelectOption, { isDisabled: option.disabled, label: option.label, value: option.value }, index))) }) }), assetType === "DMN" && (_jsxs(_Fragment, { children: [_jsx(FormGroup, { isRequired: true, label: i18n.creationPanel.dmnGroup, children: _jsx(Select, { variant: SelectVariant.single, id: "dmn-select", name: "dmn-select", onToggle: setModelSelectOpen, isOpen: isModelSelectOpen, typeAheadAriaLabel: "Select a model...", placeholderText: "Select a model...", maxHeight: "350px", onSelect: (e, dmnModelPathRelativeToThisScesim) => {
                                        if (typeof dmnModelPathRelativeToThisScesim !== "string") {
                                            throw new Error(`Invalid path for an included model ${JSON.stringify(dmnModelPathRelativeToThisScesim)}`);
                                        }
                                        console.debug(`[TestScenarioCreationPanel] Selected path ${dmnModelPathRelativeToThisScesim}`);
                                        setSelectedDmnModelPathRelativeToThisScesim(dmnModelPathRelativeToThisScesim);
                                        setModelSelectOpen(false);
                                    }, selections: selectedDmnModelPathRelativeToThisScesim, children: (((_a = allDmnModelNormalizedPosixRelativePaths === null || allDmnModelNormalizedPosixRelativePaths === void 0 ? void 0 : allDmnModelNormalizedPosixRelativePaths.length) !== null && _a !== void 0 ? _a : 0) > 0 &&
                                        (allDmnModelNormalizedPosixRelativePaths === null || allDmnModelNormalizedPosixRelativePaths === void 0 ? void 0 : allDmnModelNormalizedPosixRelativePaths.map((normalizedPosixPathRelativeToTheOpenFile) => (_jsx(SelectOption, { value: normalizedPosixPathRelativeToTheOpenFile, description: normalizedPosixPathRelativeToTheOpenFile, children: basename(normalizedPosixPathRelativeToTheOpenFile) }, normalizedPosixPathRelativeToTheOpenFile))))) || [_jsx(SelectOption, { isDisabled: true, label: i18n.creationPanel.dmnNoPresent }, undefined)] }) }), _jsx(FormGroup, { children: _jsx(Checkbox, { id: "auto-fill-table-checkbox", isChecked: isAutoFillTableEnabled, label: _jsxs(_Fragment, { children: [_jsx("span", { children: i18n.creationPanel.autoFillTable }), _jsx(Tooltip, { content: i18n.creationPanel.autoFillTableTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-creation-panel--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), onChange: (value) => {
                                        setAutoFillTableEnabled(value);
                                    } }) })] })), assetType === "RULE" && (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: i18n.creationPanel.kieSessionGroup, children: _jsx(TextInput, { onChange: (value) => setKieSessionRule(value), placeholder: "<" + i18n.creationPanel.optional + ">", type: "text", value: kieSessionRule }) }), _jsx(FormGroup, { label: i18n.creationPanel.kieAgendaGroup, children: _jsx(TextInput, { onChange: (value) => setRuleFlowGroup(value), placeholder: "<" + i18n.creationPanel.optional + ">", type: "text", value: ruleFlowGroup }) }), _jsx(FormGroup, { children: _jsx(Checkbox, { id: "stateless-session-checkbox", isChecked: isStatelessSessionRule, label: _jsxs(_Fragment, { children: [_jsx("span", { children: i18n.creationPanel.statelessSession }), _jsx(Tooltip, { content: i18n.drawer.settings.statelessSessionRuleTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-creation-panel--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), onChange: (value) => {
                                        setStatelessSessionRule(value);
                                    } }) })] })), _jsx(FormGroup, { children: _jsx(Checkbox, { id: "test-skipped-checkbox", isChecked: isTestSkipped, label: _jsxs(_Fragment, { children: [_jsx("span", { children: i18n.creationPanel.testSkip }), _jsx(Tooltip, { content: i18n.drawer.settings.testSkippedTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-creation-panel--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), onChange: (value) => {
                                setTestSkipped(value);
                            } }) })] }), assetType === "RULE" && (_jsx(Alert, { className: "kie-scesim-editor-creation-panel--rule-scesim-alert", variant: "danger", title: "Rule based Test Scenario is not supported yet." })), _jsx(Button, { icon: _jsx(AddIcon, {}), isDisabled: assetType === "" || assetType === "RULE" || (assetType === "DMN" && !selectedDmnModel), onClick: createTestScenario, variant: "primary", children: i18n.creationPanel.createButton })] }));
}
export default TestScenarioCreationPanel;
//# sourceMappingURL=TestScenarioCreationPanel.js.map