export function computeDmnDataObjects(externalModelsByNamespace, settings) {
    var _a, _b, _c, _d;
    const dataObjects = [];
    if (((_a = settings.type) === null || _a === void 0 ? void 0 : _a.__$$text) !== "DMN") {
        return dataObjects;
    }
    const dmnModel = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace.get(settings.dmnNamespace.__$$text);
    if (dmnModel) {
        const allItemDefinitionsMap = new Map((_b = dmnModel.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b.map((itemDefinition) => [itemDefinition["@_name"], itemDefinition]));
        const inputDataElements = (_c = dmnModel.model.definitions.drgElement) === null || _c === void 0 ? void 0 : _c.filter((drgElement) => drgElement.__$$element === "inputData");
        const decisionElements = (_d = dmnModel.model.definitions.drgElement) === null || _d === void 0 ? void 0 : _d.filter((drgElement) => drgElement.__$$element === "decision");
        const inpuDataObjects = inputDataElements === null || inputDataElements === void 0 ? void 0 : inputDataElements.map((inputDataElement) => createTestScenarioObjects(inputDataElement, allItemDefinitionsMap));
        const decisionDataObjects = decisionElements === null || decisionElements === void 0 ? void 0 : decisionElements.map((decisionElement) => createTestScenarioObjects(decisionElement, allItemDefinitionsMap));
        dataObjects.push(...(inpuDataObjects !== null && inpuDataObjects !== void 0 ? inpuDataObjects : []), ...(decisionDataObjects !== null && decisionDataObjects !== void 0 ? decisionDataObjects : []));
    }
    return dataObjects.sort((dataObjectA, dataObjectB) => dataObjectA.name.localeCompare(dataObjectB.name));
}
function createTestScenarioObjects(drgElement, allItemDefinitionsMap) {
    var _a;
    const drgElementName = drgElement["@_name"];
    const drgElementTypeRef = (_a = drgElement.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"];
    const itemDefinition = drgElementTypeRef ? allItemDefinitionsMap.get(drgElementTypeRef) : undefined;
    return {
        id: drgElementName,
        name: drgElementName,
        children: createChildrenTestScenarioObjects(itemDefinition, allItemDefinitionsMap, [drgElementName], drgElementTypeRef),
        className: drgElementTypeRef,
        customBadgeContent: drgElementTypeRef !== null && drgElementTypeRef !== void 0 ? drgElementTypeRef : "<Undefined>",
        expressionElements: [drgElementName],
    };
}
function createChildrenTestScenarioObjects(itemDefinition, allItemDefinitionsMap, expressionElements, rootDrgElementTypeRef) {
    var _a;
    const children = [];
    if ((itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.itemComponent) && itemDefinition.itemComponent.length > 0) {
        const childrenTestScenarioObjects = itemDefinition.itemComponent.map((itemComponent) => {
            var _a, _b, _c, _d, _e, _f, _g, _h;
            const nestedChildren = [];
            const currentItemDefinition = allItemDefinitionsMap.has((_b = (_a = itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : "")
                ? allItemDefinitionsMap.get((_d = (_c = itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent.typeRef) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "")
                : itemComponent;
            const isCollection = (_e = itemComponent["@_isCollection"]) !== null && _e !== void 0 ? _e : false;
            if (!(currentItemDefinition === null || currentItemDefinition === void 0 ? void 0 : currentItemDefinition.typeRef) && !isCollection) {
                const ns = createChildrenTestScenarioObjects(currentItemDefinition, allItemDefinitionsMap, [...expressionElements, itemComponent["@_name"]], rootDrgElementTypeRef);
                nestedChildren.push(...ns);
            }
            const name = itemComponent["@_name"];
            const className = isCollection ? "java.util.List" : (_f = itemComponent.typeRef) === null || _f === void 0 ? void 0 : _f.__$$text;
            return {
                id: [...expressionElements, name].join("."),
                hasBadge: !(className === undefined && nestedChildren.length > 0),
                name: name,
                children: nestedChildren.length > 0 ? nestedChildren : undefined,
                className: className,
                collectionGenericType: isCollection ? [itemComponent.typeRef.__$$text] : undefined,
                customBadgeContent: `${(_h = (_g = itemComponent.typeRef) === null || _g === void 0 ? void 0 : _g.__$$text) !== null && _h !== void 0 ? _h : "<Undefined>"}${isCollection ? "[]" : ""}`,
                expressionElements: [...expressionElements, name],
            };
        });
        children.push(...childrenTestScenarioObjects);
    }
    else {
        const isCollection = (_a = itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition["@_isCollection"]) !== null && _a !== void 0 ? _a : false;
        const name = "value";
        children.push({
            id: [...expressionElements, name].join("."),
            name: name,
            className: isCollection ? "java.util.List" : rootDrgElementTypeRef,
            collectionGenericType: isCollection && rootDrgElementTypeRef ? [rootDrgElementTypeRef] : undefined,
            customBadgeContent: `${rootDrgElementTypeRef !== null && rootDrgElementTypeRef !== void 0 ? rootDrgElementTypeRef : "<Undefined>"}${isCollection && rootDrgElementTypeRef ? "[]" : ""}`,
            expressionElements: expressionElements,
        });
    }
    return children.sort((childA, childB) => childA.name.localeCompare(childB.name));
}
//# sourceMappingURL=computeDmnDataObjects.js.map