import { EnvelopeBusMessageDirectSender, EnvelopeBusMessagePurpose, } from "../api";
import { EnvelopeBusMessageManager } from "../common";
export class EnvelopeClient {
    get channelApi() {
        return this.manager.clientApi;
    }
    get shared() {
        return this.manager.shared;
    }
    constructor(bus, envelopeId) {
        this.bus = bus;
        this.envelopeId = envelopeId;
        this.manager = new EnvelopeBusMessageManager((message) => this.send(message), "KogitoEnvelopeBus");
    }
    associate(origin, envelopeServerId) {
        this.targetOrigin = origin;
        this.associatedEnvelopeServerId = envelopeServerId;
    }
    startListening(apiImpl) {
        if (this.eventListener) {
            return;
        }
        this.manager.currentApiImpl = apiImpl;
        this.eventListener = (event) => this.receive(event.data, apiImpl);
        window.addEventListener("message", this.eventListener);
    }
    stopListening() {
        this.manager.currentApiImpl = undefined;
        window.removeEventListener("message", this.eventListener);
    }
    send(message) {
        if (!this.targetOrigin || !this.associatedEnvelopeServerId) {
            throw new Error("Tried to send message without associated Envelope Server set");
        }
        this.bus.postMessage({
            ...message,
            targetEnvelopeServerId: this.associatedEnvelopeServerId,
            directSender: EnvelopeBusMessageDirectSender.ENVELOPE_CLIENT,
        }, this.targetOrigin);
    }
    receive(message, apiImpl) {
        if (message.directSender === EnvelopeBusMessageDirectSender.ENVELOPE_CLIENT) {
            return;
        }
        if (this.envelopeId !== message.targetEnvelopeId) {
            return;
        }
        if (!message.targetEnvelopeServerId) {
            this.manager.server.receive(message, apiImpl);
        }
        else if (message.targetEnvelopeServerId && message.purpose === EnvelopeBusMessagePurpose.NOTIFICATION) {
            this.manager.server.receive(message, {});
        }
    }
}
//# sourceMappingURL=EnvelopeClient.js.map