import gql from "graphql-tag";
import * as ApolloReactHooks from "@apollo/react-hooks";
export var GraphQL;
(function (GraphQL) {
    const defaultOptions = {};
    let OrderBy;
    (function (OrderBy) {
        OrderBy["Asc"] = "ASC";
        OrderBy["Desc"] = "DESC";
    })(OrderBy = GraphQL.OrderBy || (GraphQL.OrderBy = {}));
    let JobStatus;
    (function (JobStatus) {
        JobStatus["Canceled"] = "CANCELED";
        JobStatus["Error"] = "ERROR";
        JobStatus["Executed"] = "EXECUTED";
        JobStatus["Retry"] = "RETRY";
        JobStatus["Scheduled"] = "SCHEDULED";
    })(JobStatus = GraphQL.JobStatus || (GraphQL.JobStatus = {}));
    let MilestoneStatus;
    (function (MilestoneStatus) {
        MilestoneStatus["Active"] = "ACTIVE";
        MilestoneStatus["Available"] = "AVAILABLE";
        MilestoneStatus["Completed"] = "COMPLETED";
    })(MilestoneStatus = GraphQL.MilestoneStatus || (GraphQL.MilestoneStatus = {}));
    let ProcessInstanceState;
    (function (ProcessInstanceState) {
        ProcessInstanceState["Aborted"] = "ABORTED";
        ProcessInstanceState["Active"] = "ACTIVE";
        ProcessInstanceState["Completed"] = "COMPLETED";
        ProcessInstanceState["Error"] = "ERROR";
        ProcessInstanceState["Pending"] = "PENDING";
        ProcessInstanceState["Suspended"] = "SUSPENDED";
    })(ProcessInstanceState = GraphQL.ProcessInstanceState || (GraphQL.ProcessInstanceState = {}));
    let __DirectiveLocation;
    (function (__DirectiveLocation) {
        __DirectiveLocation["Query"] = "QUERY";
        __DirectiveLocation["Mutation"] = "MUTATION";
        __DirectiveLocation["Subscription"] = "SUBSCRIPTION";
        __DirectiveLocation["Field"] = "FIELD";
        __DirectiveLocation["FragmentDefinition"] = "FRAGMENT_DEFINITION";
        __DirectiveLocation["FragmentSpread"] = "FRAGMENT_SPREAD";
        __DirectiveLocation["InlineFragment"] = "INLINE_FRAGMENT";
        __DirectiveLocation["VariableDefinition"] = "VARIABLE_DEFINITION";
        __DirectiveLocation["Schema"] = "SCHEMA";
        __DirectiveLocation["Scalar"] = "SCALAR";
        __DirectiveLocation["Object"] = "OBJECT";
        __DirectiveLocation["FieldDefinition"] = "FIELD_DEFINITION";
        __DirectiveLocation["ArgumentDefinition"] = "ARGUMENT_DEFINITION";
        __DirectiveLocation["Interface"] = "INTERFACE";
        __DirectiveLocation["Union"] = "UNION";
        __DirectiveLocation["Enum"] = "ENUM";
        __DirectiveLocation["EnumValue"] = "ENUM_VALUE";
        __DirectiveLocation["InputObject"] = "INPUT_OBJECT";
        __DirectiveLocation["InputFieldDefinition"] = "INPUT_FIELD_DEFINITION";
    })(__DirectiveLocation = GraphQL.__DirectiveLocation || (GraphQL.__DirectiveLocation = {}));
    let __TypeKind;
    (function (__TypeKind) {
        __TypeKind["Scalar"] = "SCALAR";
        __TypeKind["Object"] = "OBJECT";
        __TypeKind["Interface"] = "INTERFACE";
        __TypeKind["Union"] = "UNION";
        __TypeKind["Enum"] = "ENUM";
        __TypeKind["InputObject"] = "INPUT_OBJECT";
        __TypeKind["List"] = "LIST";
        __TypeKind["NonNull"] = "NON_NULL";
    })(__TypeKind = GraphQL.__TypeKind || (GraphQL.__TypeKind = {}));
    GraphQL.GetProcessDefinitionsDocument = gql `
    query getProcessDefinitions {
      ProcessDefinitions {
        id
        endpoint
        serviceUrl
      }
    }
  `;
    GraphQL.GetProcessInstancesDocument = gql `
    query getProcessInstances(
      $where: ProcessInstanceArgument
      $offset: Int
      $limit: Int
      $orderBy: ProcessInstanceOrderBy
    ) {
      ProcessInstances(where: $where, pagination: { offset: $offset, limit: $limit }, orderBy: $orderBy) {
        id
        processId
        processName
        parentProcessInstanceId
        rootProcessInstanceId
        roles
        state
        start
        lastUpdate
        addons
        businessKey
        serviceUrl
        error {
          nodeDefinitionId
          message
        }
      }
    }
  `;
    function useGetProcessInstancesQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetProcessInstancesDocument, options);
    }
    GraphQL.useGetProcessInstancesQuery = useGetProcessInstancesQuery;
    function useGetProcessInstancesLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetProcessInstancesDocument, options);
    }
    GraphQL.useGetProcessInstancesLazyQuery = useGetProcessInstancesLazyQuery;
    GraphQL.GetChildInstancesDocument = gql `
    query getChildInstances($rootProcessInstanceId: String) {
      ProcessInstances(where: { rootProcessInstanceId: { equal: $rootProcessInstanceId } }) {
        id
        processId
        processName
        parentProcessInstanceId
        rootProcessInstanceId
        roles
        state
        start
        lastUpdate
        serviceUrl
        addons
        businessKey
        error {
          nodeDefinitionId
          message
        }
      }
    }
  `;
    function useGetChildInstancesQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetChildInstancesDocument, options);
    }
    GraphQL.useGetChildInstancesQuery = useGetChildInstancesQuery;
    function useGetChildInstancesLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetChildInstancesDocument, options);
    }
    GraphQL.useGetChildInstancesLazyQuery = useGetChildInstancesLazyQuery;
    GraphQL.GetProcessInstanceByIdDocument = gql `
    query getProcessInstanceById($id: String) {
      ProcessInstances(where: { id: { equal: $id } }) {
        id
        processId
        processName
        businessKey
        parentProcessInstanceId
        parentProcessInstance {
          id
          processName
          businessKey
        }
        roles
        variables
        state
        start
        lastUpdate
        end
        addons
        endpoint
        addons
        serviceUrl
        source
        error {
          nodeDefinitionId
          message
        }
        childProcessInstances {
          id
          processName
          businessKey
        }
        nodes {
          id
          nodeId
          name
          enter
          exit
          type
          definitionId
        }
        milestones {
          id
          name
          status
        }
      }
    }
  `;
    function useGetProcessInstanceByIdQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetProcessInstanceByIdDocument, options);
    }
    GraphQL.useGetProcessInstanceByIdQuery = useGetProcessInstanceByIdQuery;
    function useGetProcessInstanceByIdLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetProcessInstanceByIdDocument, options);
    }
    GraphQL.useGetProcessInstanceByIdLazyQuery = useGetProcessInstanceByIdLazyQuery;
    GraphQL.GetColumnPickerAttributesDocument = gql `
    query getColumnPickerAttributes($columnPickerType: String!) {
      __type(name: $columnPickerType) {
        name
        fields {
          name
          type {
            name
            kind
            fields {
              name
              type {
                name
                kind
              }
            }
          }
        }
      }
    }
  `;
    function useGetColumnPickerAttributesQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetColumnPickerAttributesDocument, options);
    }
    GraphQL.useGetColumnPickerAttributesQuery = useGetColumnPickerAttributesQuery;
    function useGetColumnPickerAttributesLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetColumnPickerAttributesDocument, options);
    }
    GraphQL.useGetColumnPickerAttributesLazyQuery = useGetColumnPickerAttributesLazyQuery;
    GraphQL.GetQueryTypesDocument = gql `
    query getQueryTypes {
      __schema {
        queryType: types {
          name
          kind
          fields {
            name
            type {
              name
              kind
            }
          }
          inputFields {
            name
            type {
              name
              kind
            }
          }
        }
      }
    }
  `;
    function useGetQueryTypesQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetQueryTypesDocument, options);
    }
    GraphQL.useGetQueryTypesQuery = useGetQueryTypesQuery;
    function useGetQueryTypesLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetQueryTypesDocument, options);
    }
    GraphQL.useGetQueryTypesLazyQuery = useGetQueryTypesLazyQuery;
    GraphQL.GetQueryFieldsDocument = gql `
    query getQueryFields {
      __type(name: "Query") {
        name
        fields {
          name
          args {
            name
            type {
              kind
              name
            }
          }
          type {
            ofType {
              name
            }
          }
        }
      }
    }
  `;
    function useGetQueryFieldsQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetQueryFieldsDocument, options);
    }
    GraphQL.useGetQueryFieldsQuery = useGetQueryFieldsQuery;
    function useGetQueryFieldsLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetQueryFieldsDocument, options);
    }
    GraphQL.useGetQueryFieldsLazyQuery = useGetQueryFieldsLazyQuery;
    GraphQL.GetInputFieldsFromQueryDocument = gql `
    query getInputFieldsFromQuery($currentQuery: String!) {
      __type(name: $currentQuery) {
        name
        inputFields {
          name
          type {
            name
            kind
            inputFields {
              name
              type {
                name
              }
            }
          }
        }
      }
    }
  `;
    function useGetInputFieldsFromQueryQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetInputFieldsFromQueryDocument, options);
    }
    GraphQL.useGetInputFieldsFromQueryQuery = useGetInputFieldsFromQueryQuery;
    function useGetInputFieldsFromQueryLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetInputFieldsFromQueryDocument, options);
    }
    GraphQL.useGetInputFieldsFromQueryLazyQuery = useGetInputFieldsFromQueryLazyQuery;
    GraphQL.GetInputFieldsFromTypeDocument = gql `
    query getInputFieldsFromType($type: String!) {
      __type(name: $type) {
        name
        inputFields {
          name
          type {
            name
            kind
            enumValues {
              name
            }
            ofType {
              kind
              name
              enumValues {
                name
              }
            }
          }
        }
      }
    }
  `;
    function useGetInputFieldsFromTypeQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetInputFieldsFromTypeDocument, options);
    }
    GraphQL.useGetInputFieldsFromTypeQuery = useGetInputFieldsFromTypeQuery;
    function useGetInputFieldsFromTypeLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetInputFieldsFromTypeDocument, options);
    }
    GraphQL.useGetInputFieldsFromTypeLazyQuery = useGetInputFieldsFromTypeLazyQuery;
    GraphQL.GetUserTasksByStatesDocument = gql `
    query getUserTasksByStates($state: [String!], $orderBy: UserTaskInstanceOrderBy) {
      UserTaskInstances(where: { state: { in: $state } }, orderBy: $orderBy) {
        id
        name
        referenceName
        description
        name
        priority
        processInstanceId
        processId
        rootProcessInstanceId
        rootProcessId
        state
        actualOwner
        adminGroups
        adminUsers
        completed
        started
        excludedUsers
        potentialGroups
        potentialUsers
        inputs
        outputs
        referenceName
        endpoint
      }
    }
  `;
    function useGetUserTasksByStatesQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetUserTasksByStatesDocument, options);
    }
    GraphQL.useGetUserTasksByStatesQuery = useGetUserTasksByStatesQuery;
    function useGetUserTasksByStatesLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetUserTasksByStatesDocument, options);
    }
    GraphQL.useGetUserTasksByStatesLazyQuery = useGetUserTasksByStatesLazyQuery;
    GraphQL.GetUserTaskByIdDocument = gql `
    query getUserTaskById($id: String) {
      UserTaskInstances(where: { id: { equal: $id } }) {
        id
        description
        name
        priority
        processInstanceId
        processId
        rootProcessInstanceId
        rootProcessId
        state
        actualOwner
        adminGroups
        adminUsers
        completed
        started
        excludedUsers
        potentialGroups
        potentialUsers
        inputs
        outputs
        referenceName
        endpoint
        lastUpdate
      }
    }
  `;
    function useGetUserTaskByIdQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetUserTaskByIdDocument, options);
    }
    GraphQL.useGetUserTaskByIdQuery = useGetUserTaskByIdQuery;
    function useGetUserTaskByIdLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetUserTaskByIdDocument, options);
    }
    GraphQL.useGetUserTaskByIdLazyQuery = useGetUserTaskByIdLazyQuery;
    GraphQL.GetTasksForUserDocument = gql `
    query getTasksForUser(
      $whereArgument: UserTaskInstanceArgument
      $offset: Int
      $limit: Int
      $orderBy: UserTaskInstanceOrderBy
    ) {
      UserTaskInstances(where: $whereArgument, pagination: { offset: $offset, limit: $limit }, orderBy: $orderBy) {
        id
        name
        referenceName
        description
        priority
        processInstanceId
        processId
        rootProcessInstanceId
        rootProcessId
        state
        actualOwner
        adminGroups
        adminUsers
        completed
        started
        excludedUsers
        potentialGroups
        potentialUsers
        inputs
        outputs
        lastUpdate
        endpoint
      }
    }
  `;
    function useGetTasksForUserQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetTasksForUserDocument, options);
    }
    GraphQL.useGetTasksForUserQuery = useGetTasksForUserQuery;
    function useGetTasksForUserLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetTasksForUserDocument, options);
    }
    GraphQL.useGetTasksForUserLazyQuery = useGetTasksForUserLazyQuery;
    GraphQL.GetJobsByProcessInstanceIdDocument = gql `
    query getJobsByProcessInstanceId($processInstanceId: String) {
      Jobs(where: { processInstanceId: { equal: $processInstanceId } }) {
        id
        processId
        processInstanceId
        rootProcessId
        status
        expirationTime
        priority
        callbackEndpoint
        repeatInterval
        repeatLimit
        scheduledId
        retries
        lastUpdate
        endpoint
        nodeInstanceId
        executionCounter
      }
    }
  `;
    function useGetJobsByProcessInstanceIdQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetJobsByProcessInstanceIdDocument, options);
    }
    GraphQL.useGetJobsByProcessInstanceIdQuery = useGetJobsByProcessInstanceIdQuery;
    function useGetJobsByProcessInstanceIdLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetJobsByProcessInstanceIdDocument, options);
    }
    GraphQL.useGetJobsByProcessInstanceIdLazyQuery = useGetJobsByProcessInstanceIdLazyQuery;
    GraphQL.GetJobsWithFiltersDocument = gql `
    query getJobsWithFilters($values: [JobStatus], $orderBy: JobOrderBy, $offset: Int, $limit: Int) {
      Jobs(where: { status: { in: $values } }, orderBy: $orderBy, pagination: { offset: $offset, limit: $limit }) {
        id
        processId
        processInstanceId
        rootProcessId
        status
        expirationTime
        priority
        callbackEndpoint
        repeatInterval
        repeatLimit
        scheduledId
        retries
        lastUpdate
        endpoint
        executionCounter
      }
    }
  `;
    function useGetJobsWithFiltersQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetJobsWithFiltersDocument, options);
    }
    GraphQL.useGetJobsWithFiltersQuery = useGetJobsWithFiltersQuery;
    function useGetJobsWithFiltersLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetJobsWithFiltersDocument, options);
    }
    GraphQL.useGetJobsWithFiltersLazyQuery = useGetJobsWithFiltersLazyQuery;
    GraphQL.AbortProcessInstanceDocument = gql `
    mutation abortProcessInstance($processId: String) {
      ProcessInstanceAbort(id: $processId)
    }
  `;
    function useAbortProcessInstanceMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.AbortProcessInstanceDocument, options);
    }
    GraphQL.useAbortProcessInstanceMutation = useAbortProcessInstanceMutation;
    GraphQL.SkipProcessInstanceDocument = gql `
    mutation skipProcessInstance($processId: String) {
      ProcessInstanceSkip(id: $processId)
    }
  `;
    function useSkipProcessInstanceMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.SkipProcessInstanceDocument, options);
    }
    GraphQL.useSkipProcessInstanceMutation = useSkipProcessInstanceMutation;
    GraphQL.RetryProcessInstanceDocument = gql `
    mutation retryProcessInstance($processId: String) {
      ProcessInstanceRetry(id: $processId)
    }
  `;
    function useRetryProcessInstanceMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.RetryProcessInstanceDocument, options);
    }
    GraphQL.useRetryProcessInstanceMutation = useRetryProcessInstanceMutation;
    GraphQL.GetProcessInstanceSvgDocument = gql `
    query getProcessInstanceSVG($processId: String) {
      ProcessInstances(where: { id: { equal: $processId } }) {
        diagram
      }
    }
  `;
    function useGetProcessInstanceSvgQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetProcessInstanceSvgDocument, options);
    }
    GraphQL.useGetProcessInstanceSvgQuery = useGetProcessInstanceSvgQuery;
    function useGetProcessInstanceSvgLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetProcessInstanceSvgDocument, options);
    }
    GraphQL.useGetProcessInstanceSvgLazyQuery = useGetProcessInstanceSvgLazyQuery;
    GraphQL.GetProcessDefinitionNodesDocument = gql `
    query getProcessDefinitionNodes($processId: String) {
      ProcessDefinitions(where: { id: { equal: $processId } }) {
        nodes {
          id
          name
          type
        }
      }
    }
  `;
    function useGetProcessDefinitionNodesQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useQuery(GraphQL.GetProcessDefinitionNodesDocument, options);
    }
    GraphQL.useGetProcessDefinitionNodesQuery = useGetProcessDefinitionNodesQuery;
    function useGetProcessDefinitionNodesLazyQuery(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useLazyQuery(GraphQL.GetProcessDefinitionNodesDocument, options);
    }
    GraphQL.useGetProcessDefinitionNodesLazyQuery = useGetProcessDefinitionNodesLazyQuery;
    GraphQL.HandleNodeTriggerDocument = gql `
    mutation handleNodeTrigger($processId: String, $nodeId: String) {
      NodeInstanceTrigger(id: $processId, nodeId: $nodeId)
    }
  `;
    function useHandleNodeTriggerMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.HandleNodeTriggerDocument, options);
    }
    GraphQL.useHandleNodeTriggerMutation = useHandleNodeTriggerMutation;
    GraphQL.HandleNodeInstanceCancelDocument = gql `
    mutation handleNodeInstanceCancel($processId: String, $nodeInstanceId: String) {
      NodeInstanceCancel(id: $processId, nodeInstanceId: $nodeInstanceId)
    }
  `;
    function useHandleNodeInstanceCancelMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.HandleNodeInstanceCancelDocument, options);
    }
    GraphQL.useHandleNodeInstanceCancelMutation = useHandleNodeInstanceCancelMutation;
    GraphQL.HandleNodeInstanceRetriggerDocument = gql `
    mutation handleNodeInstanceRetrigger($processId: String, $nodeInstanceId: String) {
      NodeInstanceRetrigger(id: $processId, nodeInstanceId: $nodeInstanceId)
    }
  `;
    function useHandleNodeInstanceRetriggerMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.HandleNodeInstanceRetriggerDocument, options);
    }
    GraphQL.useHandleNodeInstanceRetriggerMutation = useHandleNodeInstanceRetriggerMutation;
    GraphQL.HandleProcessVariableUpdateDocument = gql `
    mutation handleProcessVariableUpdate($processId: String, $processInstanceVariables: String) {
      ProcessInstanceUpdateVariables(id: $processId, variables: $processInstanceVariables)
    }
  `;
    function useHandleProcessVariableUpdateMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.HandleProcessVariableUpdateDocument, options);
    }
    GraphQL.useHandleProcessVariableUpdateMutation = useHandleProcessVariableUpdateMutation;
    GraphQL.JobCancelDocument = gql `
    mutation jobCancel($jobId: String) {
      JobCancel(id: $jobId)
    }
  `;
    function useJobCancelMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.JobCancelDocument, options);
    }
    GraphQL.useJobCancelMutation = useJobCancelMutation;
    GraphQL.HandleJobRescheduleDocument = gql `
    mutation handleJobReschedule($jobId: String, $data: String) {
      JobReschedule(id: $jobId, data: $data)
    }
  `;
    function useHandleJobRescheduleMutation(baseOptions) {
        const options = { ...defaultOptions, ...baseOptions };
        return ApolloReactHooks.useMutation(GraphQL.HandleJobRescheduleDocument, options);
    }
    GraphQL.useHandleJobRescheduleMutation = useHandleJobRescheduleMutation;
})(GraphQL || (GraphQL = {}));
//# sourceMappingURL=types.js.map