import { JobOperationResult, JobStatus, Job, JobsSortBy, BulkProcessInstanceActionResponse, ProcessInstance, ProcessInstanceFilter, ProcessListSortBy, ProcessDefinition } from "../types";
import { NodeInstance, TriggerableNode, OperationType, FormInfo, Form, FormContent } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { ApolloClient } from "apollo-client";
export declare const getProcessInstances: (offset: number, limit: number, filters: ProcessInstanceFilter, sortBy: ProcessListSortBy, client: ApolloClient<any>) => Promise<ProcessInstance[]>;
export declare const getChildProcessInstances: (rootProcessInstanceId: string, client: ApolloClient<any>) => Promise<ProcessInstance[]>;
export declare const performMultipleCancel: (jobsToBeActioned: (Job & {
    errorMessage?: string;
})[], client: ApolloClient<any>) => Promise<any>;
export declare const jobCancel: (job: Job, client: ApolloClient<any>) => Promise<JobOperationResult>;
export declare const handleJobReschedule: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date, client: ApolloClient<any>) => Promise<{
    modalTitle: string;
    modalContent: string;
}>;
export declare const handleProcessSkip: (processInstance: ProcessInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleProcessRetry: (processInstance: ProcessInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleProcessAbort: (processInstance: ProcessInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleProcessMultipleAction: (processInstances: ProcessInstance[], operationType: OperationType, client: ApolloClient<any>) => Promise<BulkProcessInstanceActionResponse>;
export declare const handleNodeTrigger: (processInstance: ProcessInstance, node: TriggerableNode, client: ApolloClient<any>) => Promise<void>;
export declare const handleProcessVariableUpdate: (processInstance: ProcessInstance, updatedJson: Record<string, unknown>, client: ApolloClient<any>) => Promise<Record<string, unknown>>;
export declare const handleNodeInstanceCancel: (processInstance: ProcessInstance, node: NodeInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleNodeInstanceRetrigger: (processInstance: Pick<ProcessInstance, "id" | "serviceUrl" | "processId">, node: Pick<NodeInstance, "id">, client: ApolloClient<any>) => Promise<void>;
export declare const getSVG: (processInstance: ProcessInstance, client: ApolloClient<any>) => Promise<any>;
export declare const getProcessDetails: (id: string, client: ApolloClient<any>) => Promise<any>;
export declare const getJobs: (id: string, client: ApolloClient<any>) => Promise<any>;
export declare const getTriggerableNodes: (processInstance: ProcessInstance, client: ApolloClient<any>) => Promise<any>;
export declare const getJobsWithFilters: (offset: number, limit: number, filters: JobStatus[], orderBy: JobsSortBy, client: ApolloClient<any>) => Promise<Job[]>;
export declare const getForms: (baseUrl: string, formFilter: string[]) => Promise<FormInfo[]>;
export declare const getFormContent: (baseUrl: string, formName: string) => Promise<Form>;
export declare const saveFormContent: (baseUrl: string, formName: string, content: FormContent) => Promise<void>;
export declare const getProcessDefinitions: (client: ApolloClient<any>) => Promise<ProcessDefinition[]>;
export declare const getProcessSchema: (processDefinitionData: ProcessDefinition) => Promise<Record<string, any>>;
export declare const getCustomForm: (processDefinitionData: ProcessDefinition) => Promise<Form>;
export declare const startProcessInstance: (formData: any, businessKey: string, processDefinitionData: ProcessDefinition) => Promise<string>;
//# sourceMappingURL=apis.d.ts.map