"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmbeddedEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var api_1 = require("../../api");
var React = require("react");
var react_1 = require("react");
var channel_1 = require("../../channel");
var common_1 = require("../common");
var EmbeddedEditorChannelApiImpl_1 = require("./EmbeddedEditorChannelApiImpl");
var channel_2 = require("@kie-tools-core/envelope-bus/dist/channel");
var hooks_1 = require("@kie-tools-core/envelope-bus/dist/hooks");
var editorIframeProps_1 = require("../../channel/editorIframeProps");
var containerStyles = {
    display: "flex",
    flex: 1,
    flexDirection: "column",
    width: "100%",
    height: "100%",
    border: "none",
    margin: 0,
    padding: 0,
    overflow: "hidden",
};
var RefForwardingEmbeddedEditor = function (props, forwardedRef) {
    var iframeRef = (0, react_1.useRef)(null);
    var stateControl = (0, react_1.useMemo)(function () { var _a; return (_a = props.stateControl) !== null && _a !== void 0 ? _a : new channel_1.StateControl(); }, [props.file.getFileContents, props.stateControl]);
    var _a = __read((0, react_1.useState)(false), 2), isReady = _a[0], setReady = _a[1];
    var envelopeMapping = (0, react_1.useMemo)(function () {
        var _a;
        return props.editorEnvelopeLocator.getEnvelopeMapping((_a = props.file.normalizedPosixPathRelativeToTheWorkspaceRoot) !== null && _a !== void 0 ? _a : props.file.fileName);
    }, [props.editorEnvelopeLocator, props.file]);
    var channelApiImpl = (0, react_1.useMemo)(function () {
        var _a;
        return ((_a = props.customChannelApiImpl) !== null && _a !== void 0 ? _a : new EmbeddedEditorChannelApiImpl_1.EmbeddedEditorChannelApiImpl(stateControl, props.file, props.locale, __assign(__assign({}, props), { kogitoEditor_ready: function () {
                var _a;
                setReady(true);
                (_a = props.kogitoEditor_ready) === null || _a === void 0 ? void 0 : _a.call(props);
            } })));
    }, [stateControl, props]);
    var envelopeServer = (0, react_1.useMemo)(function () {
        return new channel_2.EnvelopeServer({ postMessage: function (message) { var _a, _b; return (_b = (_a = iframeRef.current) === null || _a === void 0 ? void 0 : _a.contentWindow) === null || _b === void 0 ? void 0 : _b.postMessage(message, "*"); } }, props.editorEnvelopeLocator.targetOrigin, function (self) {
            var _a, _b;
            return self.envelopeApi.requests.kogitoEditor_initRequest({ origin: self.origin, envelopeServerId: self.id }, {
                fileExtension: props.file.fileExtension,
                resourcesPathPrefix: (_a = envelopeMapping === null || envelopeMapping === void 0 ? void 0 : envelopeMapping.resourcesPathPrefix) !== null && _a !== void 0 ? _a : "",
                initialLocale: props.locale,
                isReadOnly: props.file.isReadOnly,
                channel: props.channelType,
                workspaceRootAbsolutePosixPath: (_b = props.workspaceRootAbsolutePosixPath) !== null && _b !== void 0 ? _b : api_1.DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH,
            });
        });
    }, [
        props.editorEnvelopeLocator.targetOrigin,
        props.file.fileExtension,
        props.file.isReadOnly,
        props.locale,
        props.channelType,
        props.workspaceRootAbsolutePosixPath,
        envelopeMapping === null || envelopeMapping === void 0 ? void 0 : envelopeMapping.resourcesPathPrefix,
    ]);
    (0, hooks_1.useConnectedEnvelopeServer)(envelopeServer, channelApiImpl);
    (0, common_1.useEffectAfterFirstRender)(function () {
        envelopeServer.envelopeApi.notifications.kogitoI18n_localeChange.send(props.locale);
    }, [props.locale]);
    (0, common_1.useEffectAfterFirstRender)(function () {
        props.file.getFileContents().then(function (content) {
            envelopeServer.envelopeApi.requests.kogitoEditor_contentChanged({ content: content, normalizedPosixPathRelativeToTheWorkspaceRoot: props.file.fileName }, { showLoadingOverlay: true });
        });
    }, [props.file.getFileContents]);
    var onKeyDown = (0, react_1.useCallback)(function (envelopeServer, ke) {
        var _a;
        var channelKeyboardEvent = {
            altKey: ke.altKey,
            ctrlKey: ke.ctrlKey,
            shiftKey: ke.shiftKey,
            metaKey: ke.metaKey,
            code: ke.code,
            type: ke.type,
            channelOriginalTargetTagName: (_a = ke.target) === null || _a === void 0 ? void 0 : _a.tagName,
        };
        console.debug("New keyboard event (".concat(JSON.stringify(channelKeyboardEvent), ")!"));
        envelopeServer.envelopeApi.notifications.kogitoKeyboardShortcuts_channelKeyboardEvent.send(channelKeyboardEvent);
    }, []);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        var _a;
        if (!iframeRef.current) {
            return undefined;
        }
        return {
            iframeRef: iframeRef,
            isReady: (_a = props.isReady) !== null && _a !== void 0 ? _a : isReady,
            getStateControl: function () { return stateControl; },
            getEnvelopeServer: function () { return envelopeServer; },
            undo: function () { return Promise.resolve(envelopeServer.envelopeApi.notifications.kogitoEditor_editorUndo.send()); },
            redo: function () { return Promise.resolve(envelopeServer.envelopeApi.notifications.kogitoEditor_editorRedo.send()); },
            getContent: function () { return envelopeServer.envelopeApi.requests.kogitoEditor_contentRequest().then(function (c) { return c.content; }); },
            getPreview: function () { return envelopeServer.envelopeApi.requests.kogitoEditor_previewRequest(); },
            setContent: function (normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
                return envelopeServer.envelopeApi.requests.kogitoEditor_contentChanged({ normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot, content: content }, { showLoadingOverlay: false });
            },
            validate: function () { return envelopeServer.envelopeApi.requests.kogitoEditor_validate(); },
            setTheme: function (theme) { return Promise.resolve(envelopeServer.shared.kogitoEditor_theme.set(theme)); },
            onKeyDown: function (ke) { return onKeyDown(envelopeServer, ke); },
        };
    }, [props.isReady, isReady, stateControl, envelopeServer, onKeyDown]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [!envelopeMapping && ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: (0, jsx_runtime_1.jsx)("span", { children: "No Editor available for '".concat(props.file.fileExtension, "' extension") }) })), envelopeMapping && ((0, jsx_runtime_1.jsx)("iframe", __assign({ ref: iframeRef, id: "kogito-iframe", "data-testid": "kogito-iframe", title: "Kogito editor", style: containerStyles, "data-envelope-channel": props.channelType }, (0, editorIframeProps_1.getEditorIframeProps)(envelopeMapping))))] }));
};
exports.EmbeddedEditor = React.forwardRef(RefForwardingEmbeddedEditor);
//# sourceMappingURL=EmbeddedEditor.js.map