"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VSCodeTestHelper = void 0;
exports.switchWebviewToFrame = switchWebviewToFrame;
exports.switchBack = switchBack;
exports.sleep = sleep;
var chai_1 = require("chai");
var path = require("path");
var fs = require("fs-extra");
var sanitize_filename_ts_1 = require("sanitize-filename-ts");
var selenium_webdriver_1 = require("selenium-webdriver");
var vscode_extension_tester_1 = require("vscode-extension-tester");
var CommonLocators_1 = require("./CommonLocators");
var KieFileExtensions_1 = require("./KieFileExtensions");
var VSCodeTestHelper = (function () {
    function VSCodeTestHelper() {
        var _this = this;
        this.EDITOR_LOADING_TIMEOUT = 60000;
        this.openFolder = function (absoluteFsPath) { return __awaiter(_this, void 0, void 0, function () {
            var control, _a, _b, _c, folderName, _d;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0: return [4, this.browser.openResources(absoluteFsPath)];
                    case 1:
                        _e.sent();
                        return [4, new vscode_extension_tester_1.ActivityBar().getViewControl("Explorer")];
                    case 2:
                        control = (_e.sent());
                        _a = this;
                        return [4, control.openView()];
                    case 3:
                        _a.sidebarView = _e.sent();
                        _c = (_b = chai_1.assert).isTrue;
                        return [4, this.sidebarView.isDisplayed()];
                    case 4:
                        _c.apply(_b, [_e.sent(), "Explorer side bar view was not opened"]);
                        folderName = absoluteFsPath.split(path.sep).pop();
                        if (folderName == undefined) {
                            throw new Error("Invalid path: " + absoluteFsPath);
                        }
                        _d = this;
                        return [4, this.sidebarView.getContent().getSection(folderName)];
                    case 5:
                        _d.workspaceSectionView = _e.sent();
                        return [2, this.sidebarView];
                }
            });
        }); };
        this.openFileFromSidebar = function (fileName, fileParentPath) { return __awaiter(_this, void 0, void 0, function () {
            var webView;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(0, KieFileExtensions_1.isKieEditorWithSingleView)(fileName)) return [3, 2];
                        return [4, this.openEditorWithOneWebView(fileName, fileParentPath)];
                    case 1:
                        webView = _a.sent();
                        return [2, [webView]];
                    case 2:
                        if (!(0, KieFileExtensions_1.isKieEditorWithDualView)(fileName)) return [3, 4];
                        return [4, this.openEditorWithTwoWebViews(fileName, fileParentPath)];
                    case 3: return [2, _a.sent()];
                    case 4: return [4, this.openNonKieEditorFile(fileName, fileParentPath)];
                    case 5: return [2, _a.sent()];
                }
            });
        }); };
        this.openEditorWithOneWebView = function (fileName, fileParentPath) { return __awaiter(_this, void 0, void 0, function () {
            var editorGroups, webview;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.openItemFromSidebar(fileName, fileParentPath)];
                    case 1:
                        editorGroups = _a.sent();
                        chai_1.assert.equal(editorGroups.length, 1);
                        webview = new vscode_extension_tester_1.WebView(this.workbench.getEditorView(), vscode_extension_tester_1.By.linkText(fileName));
                        return [4, this.waitUntilKogitoEditorIsLoaded(webview)];
                    case 2:
                        _a.sent();
                        return [2, webview];
                }
            });
        }); };
        this.openEditorWithTwoWebViews = function (fileName, fileParentPath) { return __awaiter(_this, void 0, void 0, function () {
            var editorGroups, webviewLeft, webviewRight, webviews;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.openItemFromSidebar(fileName, fileParentPath)];
                    case 1:
                        editorGroups = _a.sent();
                        chai_1.assert.equal(editorGroups.length, 2);
                        webviewLeft = new vscode_extension_tester_1.WebView(editorGroups[0], vscode_extension_tester_1.By.linkText(fileName));
                        if ((0, KieFileExtensions_1.isDashbuilderEditor)(fileName)) {
                            this.forceOpeningDashbuilderEditor(webviewLeft);
                        }
                        webviewRight = new vscode_extension_tester_1.WebView(editorGroups[1], vscode_extension_tester_1.By.linkText(fileName));
                        return [4, this.waitUntilKogitoEditorIsLoaded(webviewRight)];
                    case 2:
                        _a.sent();
                        webviews = [];
                        webviews.push(webviewLeft);
                        webviews.push(webviewRight);
                        return [2, Promise.resolve(webviews)];
                }
            });
        }); };
        this.openNonKieEditorFile = function (fileName, fileParentPath) { return __awaiter(_this, void 0, void 0, function () {
            var editorGroups, webviews;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.openItemFromSidebar(fileName, fileParentPath)];
                    case 1:
                        editorGroups = _a.sent();
                        webviews = [];
                        editorGroups.forEach(function (editorGroup) {
                            var webview = new vscode_extension_tester_1.WebView(editorGroup, vscode_extension_tester_1.By.linkText(fileName));
                            webviews.push(webview);
                        });
                        return [2, Promise.resolve(webviews)];
                }
            });
        }); };
        this.openItemFromSidebar = function (fileName, fileParentPath) { return __awaiter(_this, void 0, void 0, function () {
            var pathPieces, fileItem;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(fileParentPath == undefined || fileParentPath == "")) return [3, 2];
                        return [4, this.workspaceSectionView.openItem(fileName)];
                    case 1:
                        _b.sent();
                        return [3, 7];
                    case 2:
                        pathPieces = fileParentPath.split("/");
                        return [4, (_a = this.workspaceSectionView).openItem.apply(_a, __spreadArray([], __read(pathPieces), false))];
                    case 3:
                        _b.sent();
                        return [4, this.waitUntilFolderStructureIsExpanded(pathPieces[0])];
                    case 4:
                        _b.sent();
                        return [4, this.workspaceSectionView.findItem(fileName)];
                    case 5:
                        fileItem = _b.sent();
                        if (!(fileItem != undefined)) return [3, 7];
                        return [4, fileItem.click()];
                    case 6:
                        _b.sent();
                        _b.label = 7;
                    case 7: return [4, sleep(5000)];
                    case 8:
                        _b.sent();
                        return [4, this.workbench.getEditorView().getEditorGroups()];
                    case 9: return [2, _b.sent()];
                }
            });
        }); };
        this.waitUntilFolderStructureIsExpanded = function (topLevelFolderName) { return __awaiter(_this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.driver.wait(function () { return __awaiter(_this, void 0, void 0, function () {
                            var currentValue;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4, this.driver
                                            .findElement((0, CommonLocators_1.explorerFolder)(topLevelFolderName))
                                            .getAttribute("aria-expanded")];
                                    case 1:
                                        currentValue = _a.sent();
                                        return [2, currentValue === "true"];
                                }
                            });
                        }); }, 25000, "Folder structure didn't expand in time. Please investigate.")];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        }); };
        this.renameFile = function (fileName, newFileName) { return __awaiter(_this, void 0, void 0, function () {
            var fileNameToRename, pathPieces, fileItem, menu, inputElement, renamedFileName, _a;
            var _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        fileNameToRename = fileName;
                        if (!fileName.includes("/")) return [3, 2];
                        pathPieces = fileName.split("/");
                        fileNameToRename = pathPieces.pop();
                        return [4, (_b = this.workspaceSectionView).openItem.apply(_b, __spreadArray([], __read(pathPieces), false))];
                    case 1:
                        _c.sent();
                        _c.label = 2;
                    case 2:
                        if (!(fileNameToRename != undefined)) return [3, 4];
                        return [4, this.workspaceSectionView.findItem(fileNameToRename)];
                    case 3:
                        fileItem = _c.sent();
                        _c.label = 4;
                    case 4: return [4, (fileItem === null || fileItem === void 0 ? void 0 : fileItem.openContextMenu())];
                    case 5:
                        menu = _c.sent();
                        return [4, (menu === null || menu === void 0 ? void 0 : menu.select("Rename..."))];
                    case 6:
                        _c.sent();
                        return [4, this.workspaceSectionView.findElement((0, CommonLocators_1.inputBox)())];
                    case 7:
                        inputElement = _c.sent();
                        return [4, inputElement.sendKeys(selenium_webdriver_1.Key.chord(selenium_webdriver_1.Key.CONTROL, "a"))];
                    case 8:
                        _c.sent();
                        return [4, inputElement.sendKeys(newFileName)];
                    case 9:
                        _c.sent();
                        return [4, inputElement.sendKeys(selenium_webdriver_1.Key.ENTER)];
                    case 10:
                        _c.sent();
                        renamedFileName = newFileName.includes("/") ? newFileName.split("/").pop() : newFileName;
                        (0, chai_1.expect)(renamedFileName).to.exist;
                        _a = chai_1.expect;
                        return [4, this.workspaceSectionView.findItem(renamedFileName)];
                    case 11:
                        _a.apply(void 0, [_c.sent()]).to.exist;
                        return [2];
                }
            });
        }); };
        this.closeAllEditors = function () { return __awaiter(_this, void 0, void 0, function () {
            var error_1, dialog, _a, error_2;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 2, , 10]);
                        return [4, this.workbench.getEditorView().closeAllEditors()];
                    case 1:
                        _b.sent();
                        return [3, 10];
                    case 2:
                        error_1 = _b.sent();
                        console.log("Error while closing all editors: " + error_1);
                        _b.label = 3;
                    case 3:
                        _b.trys.push([3, 8, , 9]);
                        dialog = new vscode_extension_tester_1.ModalDialog();
                        _a = dialog != null;
                        if (!_a) return [3, 5];
                        return [4, dialog.isDisplayed()];
                    case 4:
                        _a = (_b.sent());
                        _b.label = 5;
                    case 5:
                        if (!_a) return [3, 7];
                        return [4, dialog.pushButton("Don't Save")];
                    case 6:
                        _b.sent();
                        _b.label = 7;
                    case 7: return [3, 9];
                    case 8:
                        error_2 = _b.sent();
                        console.log("Error while pushButton called: " + error_2);
                        return [3, 9];
                    case 9: return [3, 10];
                    case 10: return [2];
                }
            });
        }); };
        this.closeAllNotifications = function () { return __awaiter(_this, void 0, void 0, function () {
            var activeNotifications, activeNotifications_1, activeNotifications_1_1, notification, e_1_1, e_2;
            var e_1, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 10, , 11]);
                        return [4, this.workbench.getNotifications()];
                    case 1:
                        activeNotifications = _b.sent();
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 7, 8, 9]);
                        activeNotifications_1 = __values(activeNotifications), activeNotifications_1_1 = activeNotifications_1.next();
                        _b.label = 3;
                    case 3:
                        if (!!activeNotifications_1_1.done) return [3, 6];
                        notification = activeNotifications_1_1.value;
                        return [4, notification.dismiss()];
                    case 4:
                        _b.sent();
                        _b.label = 5;
                    case 5:
                        activeNotifications_1_1 = activeNotifications_1.next();
                        return [3, 3];
                    case 6: return [3, 9];
                    case 7:
                        e_1_1 = _b.sent();
                        e_1 = { error: e_1_1 };
                        return [3, 9];
                    case 8:
                        try {
                            if (activeNotifications_1_1 && !activeNotifications_1_1.done && (_a = activeNotifications_1.return)) _a.call(activeNotifications_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                        return [7];
                    case 9: return [3, 11];
                    case 10:
                        e_2 = _b.sent();
                        console.log("Error while closing all notifications: " + e_2);
                        return [3, 11];
                    case 11: return [2];
                }
            });
        }); };
        this.waitUntilKogitoEditorIsLoaded = function (webview) { return __awaiter(_this, void 0, void 0, function () {
            var driver;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        driver = webview.getDriver();
                        switchWebviewToFrame(webview);
                        return [4, driver.wait(vscode_extension_tester_1.until.elementLocated((0, CommonLocators_1.envelopeApp)()), this.EDITOR_LOADING_TIMEOUT, "No 'div#envelope-app' located in webview's active-frame in " +
                                this.EDITOR_LOADING_TIMEOUT +
                                "ms. Please investigate.")];
                    case 1:
                        _a.sent();
                        return [4, driver.wait(function () { return __awaiter(_this, void 0, void 0, function () {
                                var loadingSpinners;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4, webview.getDriver().findElements((0, CommonLocators_1.kogitoLoadingSpinner)())];
                                        case 1:
                                            loadingSpinners = _a.sent();
                                            return [2, !loadingSpinners || loadingSpinners.length <= 0];
                                    }
                                });
                            }); }, this.EDITOR_LOADING_TIMEOUT, "Editor was still loading after " + this.EDITOR_LOADING_TIMEOUT + "ms. Please investigate.")];
                    case 2:
                        _a.sent();
                        return [4, sleep(8000)];
                    case 3:
                        _a.sent();
                        return [4, switchBack(webview)];
                    case 4:
                        _a.sent();
                        return [2];
                }
            });
        }); };
        this.executeCommandFromPrompt = function (command) { return __awaiter(_this, void 0, void 0, function () {
            var inputBox, quickPicks, quickPicks_1, quickPicks_1_1, quickPick, label, e_3_1;
            var e_3, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, this.workbench.openCommandPrompt()];
                    case 1:
                        inputBox = (_b.sent());
                        return [4, inputBox.setText(">".concat(command))];
                    case 2:
                        _b.sent();
                        return [4, inputBox.getQuickPicks()];
                    case 3:
                        quickPicks = _b.sent();
                        _b.label = 4;
                    case 4:
                        _b.trys.push([4, 11, 12, 13]);
                        quickPicks_1 = __values(quickPicks), quickPicks_1_1 = quickPicks_1.next();
                        _b.label = 5;
                    case 5:
                        if (!!quickPicks_1_1.done) return [3, 10];
                        quickPick = quickPicks_1_1.value;
                        return [4, quickPick.getLabel()];
                    case 6:
                        label = _b.sent();
                        if (!(label === command)) return [3, 9];
                        return [4, quickPick.select()];
                    case 7:
                        _b.sent();
                        return [4, sleep(1000)];
                    case 8:
                        _b.sent();
                        return [2];
                    case 9:
                        quickPicks_1_1 = quickPicks_1.next();
                        return [3, 5];
                    case 10: return [3, 13];
                    case 11:
                        e_3_1 = _b.sent();
                        e_3 = { error: e_3_1 };
                        return [3, 13];
                    case 12:
                        try {
                            if (quickPicks_1_1 && !quickPicks_1_1.done && (_a = quickPicks_1.return)) _a.call(quickPicks_1);
                        }
                        finally { if (e_3) throw e_3.error; }
                        return [7];
                    case 13: throw new Error("'".concat(command, "' not found in prompt"));
                }
            });
        }); };
        this.takeScreenshotOnTestFailure = function (testMochaContext, parentScreenshotFolder) { return __awaiter(_this, void 0, void 0, function () {
            var screenshotName, screenshotDir;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(testMochaContext.currentTest && testMochaContext.currentTest.state !== "passed")) return [3, 2];
                        screenshotName = ((_a = testMochaContext.currentTest) === null || _a === void 0 ? void 0 : _a.fullTitle()) + " (failed)";
                        screenshotDir = path.join(parentScreenshotFolder, "screenshots");
                        return [4, this.takeScreenshotAndSave(screenshotName, screenshotDir)];
                    case 1:
                        _b.sent();
                        _b.label = 2;
                    case 2: return [2];
                }
            });
        }); };
        this.takeScreenshotAndSave = function (name, dirPath) { return __awaiter(_this, void 0, void 0, function () {
            var data;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.driver.takeScreenshot()];
                    case 1:
                        data = _a.sent();
                        fs.mkdirpSync(dirPath);
                        fs.writeFileSync(path.join(dirPath, "".concat((0, sanitize_filename_ts_1.sanitize)(name), ".png")), data, "base64");
                        return [2];
                }
            });
        }); };
        this.saveFileInTextEditor = function () { return __awaiter(_this, void 0, void 0, function () {
            var textEditor;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        textEditor = new vscode_extension_tester_1.TextEditor(this.workbench.getEditorView());
                        return [4, textEditor.save()];
                    case 1:
                        _a.sent();
                        return [4, sleep(1000)];
                    case 2:
                        _a.sent();
                        return [2];
                }
            });
        }); };
        this.setVSCodeSettings = function () {
            var settings = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                settings[_i] = arguments[_i];
            }
            return __awaiter(_this, void 0, void 0, function () {
                var previousSettingValuesArray, settingsEditor, settings_1, settings_1_1, _a, settingValue, settingName, settingCategories, locatedSetting, previousSettingValue, e_4_1;
                var e_4, _b;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            previousSettingValuesArray = [];
                            return [4, new vscode_extension_tester_1.Workbench().openSettings()];
                        case 1:
                            settingsEditor = _c.sent();
                            _c.label = 2;
                        case 2:
                            _c.trys.push([2, 9, 10, 11]);
                            settings_1 = __values(settings), settings_1_1 = settings_1.next();
                            _c.label = 3;
                        case 3:
                            if (!!settings_1_1.done) return [3, 8];
                            _a = settings_1_1.value, settingValue = _a.settingValue, settingName = _a.settingName, settingCategories = _a.settingCategories;
                            return [4, settingsEditor.findSetting.apply(settingsEditor, __spreadArray([settingName], __read((settingCategories || [])), false))];
                        case 4:
                            locatedSetting = _c.sent();
                            return [4, locatedSetting.getValue()];
                        case 5:
                            previousSettingValue = _c.sent();
                            previousSettingValuesArray.push(previousSettingValue);
                            return [4, locatedSetting.setValue(settingValue)];
                        case 6:
                            _c.sent();
                            _c.label = 7;
                        case 7:
                            settings_1_1 = settings_1.next();
                            return [3, 3];
                        case 8: return [3, 11];
                        case 9:
                            e_4_1 = _c.sent();
                            e_4 = { error: e_4_1 };
                            return [3, 11];
                        case 10:
                            try {
                                if (settings_1_1 && !settings_1_1.done && (_b = settings_1.return)) _b.call(settings_1);
                            }
                            finally { if (e_4) throw e_4.error; }
                            return [7];
                        case 11: return [4, new vscode_extension_tester_1.EditorView().closeEditor("Settings")];
                        case 12:
                            _c.sent();
                            return [4, sleep(1000)];
                        case 13:
                            _c.sent();
                            return [2, previousSettingValuesArray];
                    }
                });
            });
        };
        this.workbench = new vscode_extension_tester_1.Workbench();
        this.browser = vscode_extension_tester_1.VSBrowser.instance;
        this.driver = this.browser.driver;
    }
    VSCodeTestHelper.prototype.forceOpeningDashbuilderEditor = function (textEditorWebView) {
        return __awaiter(this, void 0, void 0, function () {
            var webDriver, consoleHelper;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        webDriver = textEditorWebView.getDriver();
                        return [4, webDriver.findElement((0, CommonLocators_1.webViewReady)())];
                    case 1:
                        consoleHelper = _a.sent();
                        return [4, consoleHelper.sendKeys(selenium_webdriver_1.Key.ENTER)];
                    case 2:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    return VSCodeTestHelper;
}());
exports.VSCodeTestHelper = VSCodeTestHelper;
function switchWebviewToFrame(webview) {
    return __awaiter(this, void 0, void 0, function () {
        var driver, _a, _b, _c, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    driver = webview.getDriver();
                    return [4, driver.wait(vscode_extension_tester_1.until.elementLocated((0, CommonLocators_1.webViewReady)()), 10000, "No iframe.webview.ready that was ready was located in webview under 10 seconds." +
                            "This should not happen and is most probably issue of VSCode." +
                            "In case this happens investigate vscode or vscode-extension-tester dependency.")];
                case 1:
                    _e.sent();
                    _b = (_a = driver.switchTo()).frame;
                    return [4, driver.findElement((0, CommonLocators_1.webViewReady)())];
                case 2: return [4, _b.apply(_a, [_e.sent()])];
                case 3:
                    _e.sent();
                    return [4, driver.wait(vscode_extension_tester_1.until.elementLocated((0, CommonLocators_1.activeFrame)()), 10000, "No iframe#active-frame located in webview under 10 seconds." +
                            "This should not happen and is most probably issue of VSCode." +
                            "In case this happens investigate vscode or vscode-extension-tester dependency.")];
                case 4:
                    _e.sent();
                    _d = (_c = driver.switchTo()).frame;
                    return [4, driver.findElement((0, CommonLocators_1.activeFrame)())];
                case 5: return [4, _d.apply(_c, [_e.sent()])];
                case 6:
                    _e.sent();
                    return [2];
            }
        });
    });
}
function switchBack(webview) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, webview.getDriver().switchTo().frame(null)];
                case 1:
                    _a.sent();
                    return [2];
            }
        });
    });
}
function sleep(ms) {
    return new Promise(function (resolve) { return setTimeout(resolve, ms); });
}
//# sourceMappingURL=VSCodeTestHelper.js.map