"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.indentText = indentText;
function indentText(text, indentNum, indentChar, skipFirstLine) {
    if (indentNum === void 0) { indentNum = 0; }
    if (indentChar === void 0) { indentChar = " "; }
    if (skipFirstLine === void 0) { skipFirstLine = true; }
    if (!text) {
        return "";
    }
    var indentation = new Array(indentNum).fill(indentChar).join("");
    var indentedText = text.replace(/^/gm, indentation);
    return !skipFirstLine ? indentedText : indentedText.replace(indentation, "");
}
//# sourceMappingURL=indentText.js.map