import { By } from "selenium-webdriver";
import PageFragment from "../PageFragment";
class Editor extends PageFragment {
    async waitUntilLoaded() {
        await this.enter();
        if (await this.tools.by(Editor.LOADING_POPUP_LOCATOR).wait(10000).isPresent()) {
            await this.tools.by(Editor.LOADING_POPUP_LOCATOR).wait(30000).untilAbsent();
        }
        await this.tools.by(Editor.ENVELOPE_LOCATOR).wait(5000).untilPresent();
        return await this.leave();
    }
    async enter() {
        return await this.root.enterFrame();
    }
    async leave() {
        return await this.tools.window().leaveFrame();
    }
}
Editor.LOADING_POPUP_LOCATOR = By.className("pf-l-bullseye");
Editor.ENVELOPE_LOCATOR = By.xpath("//div[@id='envelope-app' or @id='combined-envelope-app']");
export default Editor;
//# sourceMappingURL=Editor.js.map