import { jsx as _jsx } from "react/jsx-runtime";
import { EditorTheme, useKogitoEditorEnvelopeContext, } from "@kie-tools-core/editor/dist/api";
import { useSharedValue } from "@kie-tools-core/envelope-bus/dist/hooks";
import { extname } from "path";
import * as React from "react";
import { useEffect, useImperativeHandle, useMemo, useRef } from "react";
import { MonacoEditorController } from "./MonacoEditorController";
const extensionLanguageMap = new Map([
    [".yml", "yaml"],
    [".bpmn", "xml"],
    [".bpmn2", "xml"],
    [".dmn", "xml"],
    [".scesim", "xml"],
    [".pmml", "xml"],
    [".md", "markdown"],
]);
const RefForwardingMonacoEditor = ({ content, fileName, onContentChange, channelType, isReadOnly, setValidationErrors }, forwardedRef) => {
    var _a;
    const container = useRef(null);
    const editorEnvelopeCtx = useKogitoEditorEnvelopeContext();
    const [theme] = useSharedValue((_a = editorEnvelopeCtx.channelApi) === null || _a === void 0 ? void 0 : _a.shared.kogitoEditor_theme);
    const controller = useMemo(() => {
        var _a;
        return new MonacoEditorController(content, onContentChange, (_a = extensionLanguageMap.get(extname(fileName.toLowerCase()))) !== null && _a !== void 0 ? _a : extname(fileName).slice(1), editorEnvelopeCtx.operatingSystem, isReadOnly, setValidationErrors);
    }, [content, editorEnvelopeCtx.operatingSystem, fileName, isReadOnly, onContentChange, setValidationErrors]);
    useEffect(() => {
        controller.forceRedraw();
    }, [controller]);
    useEffect(() => {
        if (!container.current) {
            return;
        }
        if (editorEnvelopeCtx.channelApi && theme === undefined) {
            return;
        }
        controller.show(container.current, theme !== null && theme !== void 0 ? theme : EditorTheme.LIGHT);
        return () => {
            controller.dispose();
        };
    }, [
        content,
        fileName,
        channelType,
        controller,
        theme,
        editorEnvelopeCtx.channelApi,
        editorEnvelopeCtx.operatingSystem,
    ]);
    useImperativeHandle(forwardedRef, () => controller, [controller]);
    return _jsx("div", { style: { height: "100%" }, ref: container });
};
export const MonacoEditor = React.forwardRef(RefForwardingMonacoEditor);
//# sourceMappingURL=MonacoEditor.js.map