import { Job, JobCancel, WorkflowInstance } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { WorkflowDetailsChannelApi, WorkflowDetailsDriver } from "../api";
import { TriggerableNode, NodeInstance } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export declare class WorkflowDetailsChannelApiImpl implements WorkflowDetailsChannelApi {
    private readonly driver;
    constructor(driver: WorkflowDetailsDriver);
    workflowDetails__handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    workflowDetails__cancelJob(job: Pick<Job, "id" | "endpoint">): Promise<JobCancel>;
    workflowDetails__rescheduleJob(job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    workflowDetails__getTriggerableNodes(workflowInstance: WorkflowInstance): Promise<TriggerableNode[]>;
    workflowDetails__handleNodeTrigger(workflowInstance: WorkflowInstance, node: TriggerableNode): Promise<void>;
    workflowDetails__handleWorkflowVariableUpdate(workflowInstance: WorkflowInstance, updatedJson: Record<string, unknown>): Promise<Record<string, unknown>>;
    workflowDetails__workflowDetailsQuery(id: string): Promise<WorkflowInstance>;
    workflowDetails__jobsQuery(id: string): Promise<Job[]>;
    workflowDetails__openWorkflowDetails(id: string): void;
    workflowDetails__handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    workflowDetails__handleNodeInstanceCancel(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
    workflowDetails__handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    workflowDetails__handleNodeInstanceRetrigger(workflowInstance: WorkflowInstance, node: Pick<NodeInstance, "id">): Promise<void>;
}
//# sourceMappingURL=WorkflowDetailsChannelApiImpl.d.ts.map